/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.router;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.uca.rs.router.Hub;
import io.vertx.up.uca.rs.router.MediaHub;
import io.vertx.up.uca.rs.router.Pool;
import io.vertx.up.uca.rs.router.UriHub;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class FilterAxis
implements Axis<Router> {
    private static final Annal LOGGER = Annal.get(FilterAxis.class);
    private static final ConcurrentMap<String, Set<Event>> FILTERS = ZeroAnno.getFilters();

    @Override
    public void mount(Router router) {
        FILTERS.forEach((path, events) -> events.forEach(event -> Fn.safeSemi((null == event ? 1 : 0) != 0, (Annal)LOGGER, () -> LOGGER.warn("( {0} ) The system found \"null\" event in the queue. ", new Object[]{this.getClass().getName()}), () -> {
            Route route = router.route();
            Hub hub = (Hub)Fn.poolThread(Pool.URIHUBS, () -> (Hub)Ut.instance(UriHub.class, (Object[])new Object[0]));
            hub.mount(route, (Event)event);
            hub = (Hub)Fn.poolThread(Pool.MEDIAHUBS, () -> (Hub)Ut.instance(MediaHub.class, (Object[])new Object[0]));
            hub.mount(route, (Event)event);
            route.handler(context -> {
                Method method = event.getAction();
                Object proxy = event.getProxy();
                this.execute((RoutingContext)context, proxy, method);
            });
        })));
    }

    private void execute(RoutingContext context, Object proxy, Method method) {
        Fn.safeNull(() -> Fn.safeJvm(() -> {
            Ut.invoke((Object)proxy, (String)"init", (Object[])new Object[]{context});
            HttpServerRequest request = context.request();
            HttpServerResponse response = context.response();
            method.invoke(proxy, request, response);
            if (!response.ended()) {
                context.next();
            }
        }, (Annal)LOGGER), (Object[])new Object[]{method, proxy});
    }
}

