/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.anima;

import io.reactivex.Observable;
import io.vertx.core.Vertx;
import io.vertx.tp.error.PluginSpecificationException;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.eon.Plugins;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.Runner;
import io.vertx.up.runtime.ZeroAmbient;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.uca.di.DiPlugin;
import io.vertx.up.uca.web.anima.Scatter;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroLime;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class InfixScatter
implements Scatter<Vertx> {
    private static final Annal LOGGER = Annal.get(InfixScatter.class);
    private static final Node<ConcurrentMap<String, String>> LIME = (Node)Ut.singleton(ZeroLime.class, (Object[])new Object[0]);
    private static final Set<Class<?>> PLUGINS = ZeroAnno.getTps();
    private static final DiPlugin PLUGIN = DiPlugin.create(InfixScatter.class);

    @Override
    public void connect(Vertx vertx) {
        ConcurrentMap wholeInjections = ZeroAmbient.getInjections();
        ConcurrentMap enabled = Ut.reduce(((ConcurrentMap)LIME.read()).keySet(), (ConcurrentMap)wholeInjections);
        ConcurrentMap injections = Ut.reduce((ConcurrentMap)Plugins.INFIX_MAP, (ConcurrentMap)enabled);
        injections.values().forEach(item -> {
            if (null != item && item.isAnnotationPresent(Plugin.class)) {
                Method method = this.findInit((Class<?>)item);
                Fn.outUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, PluginSpecificationException.class, (Object[])new Object[]{this.getClass(), item.getName()});
                Fn.safeJvm(() -> method.invoke(null, vertx), (Annal)LOGGER);
            }
        });
        Observable.fromIterable(wholeInjections.keySet()).filter(key -> !Plugins.Infix.STANDAND.contains(key)).map(wholeInjections::get).filter(Objects::nonNull).filter(item -> item.isAnnotationPresent(Plugin.class)).subscribe(item -> {
            Method method = this.findInit((Class<?>)item);
            Fn.outUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, PluginSpecificationException.class, (Object[])new Object[]{this.getClass(), item.getName()});
            Fn.safeJvm(() -> method.invoke(null, vertx), (Annal)LOGGER);
        }).dispose();
        Ut.itSet(PLUGINS, (clazz, index) -> Runner.run(() -> {
            Object reference = Ut.singleton((Class)clazz, (Object[])new Object[0]);
            PLUGIN.inject(reference);
        }, (String)"injects-plugin-scannner"));
    }

    private Method findInit(Class<?> clazz) {
        return (Method)Fn.getNull(() -> {
            Method[] methods = clazz.getDeclaredMethods();
            List found = Arrays.stream(methods).filter(item -> "init".equals(item.getName()) && this.validMethod((Method)item)).collect(Collectors.toList());
            return 1 == found.size() ? (Method)found.get(0) : null;
        }, (Object[])new Object[]{clazz});
    }

    private boolean validMethod(Method method) {
        return (Void.TYPE == method.getReturnType() || Void.class == method.getReturnType()) && Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }
}

