/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.failure;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.rs.hunt.Answer;
import io.vertx.up.unity.Ux;

public class AuthenticateEndurer
implements Handler<RoutingContext> {
    private static final Annal LOGGER = Annal.get(AuthenticateEndurer.class);

    private AuthenticateEndurer() {
    }

    public static Handler<RoutingContext> create() {
        return new AuthenticateEndurer();
    }

    public void handle(RoutingContext event) {
        if (event.failed()) {
            Throwable ex = event.failure();
            if (ex instanceof WebException) {
                LOGGER.info("Web Exception: {0} = {1}", new Object[]{ex.getClass().getName(), ex.getMessage()});
                WebException error = (WebException)ex;
                Ux.debug((Throwable)error, () -> error);
                Answer.reply(event, Envelop.failure(error));
            } else {
                LOGGER.info("Exception: {0} = {1}", new Object[]{ex.getClass().getName(), ex.getMessage()});
                ex.printStackTrace();
                event.fail(ex);
            }
        } else {
            event.next();
        }
    }
}

