/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import io.reactivex.Observable;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.up.annotations.Ordered;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.web.filter.Filter;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.FilterInitialException;
import io.vertx.zero.exception.FilterOrderException;
import io.vertx.zero.exception.FilterSpecificationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.annotation.WebFilter;
import javax.ws.rs.core.MediaType;

public class FilterInquirer
implements Inquirer<ConcurrentMap<String, Set<Event>>> {
    private static final Annal LOGGER = Annal.get(FilterInquirer.class);

    @Override
    public ConcurrentMap<String, Set<Event>> scan(Set<Class<?>> clazzes) {
        ConcurrentHashMap<String, Set<Event>> filters = new ConcurrentHashMap<String, Set<Event>>();
        Observable.fromIterable(clazzes).filter(item -> item.isAnnotationPresent(WebFilter.class)).map(this::ensure).subscribe(item -> this.extract((ConcurrentMap<String, Set<Event>>)filters, (Class<?>)item)).dispose();
        return filters;
    }

    private Class<?> ensure(Class<?> clazz) {
        Fn.outUp((!Filter.class.isAssignableFrom(clazz) ? 1 : 0) != 0, (Annal)LOGGER, FilterSpecificationException.class, (Object[])new Object[]{this.getClass(), clazz});
        return clazz;
    }

    private void extract(ConcurrentMap<String, Set<Event>> map, Class<?> clazz) {
        String[] pathes;
        WebFilter annotation = clazz.getAnnotation(WebFilter.class);
        for (String path : pathes = (String[])Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0])) {
            Event event = this.extract(path, clazz);
            if (null == event) continue;
            HashSet<Event> events = (HashSet<Event>)map.get(path);
            if (null == events) {
                events = new HashSet<Event>();
            }
            events.add(event);
            map.put(path, events);
        }
    }

    private Event extract(String path, Class<?> clazz) {
        Event event = new Event();
        event.setPath(path);
        Ordered annotation = clazz.getAnnotation(Ordered.class);
        int order = 1800000;
        if (null != annotation) {
            Integer setted = (Integer)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            Fn.outUp((setted < 0 ? 1 : 0) != 0, (Annal)LOGGER, FilterOrderException.class, (Object[])new Object[]{this.getClass(), clazz});
            order += setted.intValue();
        }
        event.setOrder(order);
        Object proxy = Ut.singleton(clazz, (Object[])new Object[0]);
        Fn.outUp((null == proxy ? 1 : 0) != 0, (Annal)LOGGER, FilterInitialException.class, (Object[])new Object[]{this.getClass(), clazz});
        event.setProxy(proxy);
        Method action = this.findMethod(clazz);
        event.setAction(action);
        event.setConsumes(new HashSet<MediaType>());
        event.setProduces(new HashSet<MediaType>());
        return event;
    }

    private Method findMethod(Class<?> clazz) {
        ArrayList methods = new ArrayList();
        Object[] scanned = clazz.getDeclaredMethods();
        Observable.fromArray((Object[])scanned).filter(item -> "doFilter".equals(item.getName())).subscribe(methods::add).dispose();
        if (1 == methods.size()) {
            return (Method)methods.get(0);
        }
        return (Method)Observable.fromIterable(methods).filter(this::isValidFilter).blockingFirst();
    }

    private boolean isValidFilter(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        boolean valid = false;
        if (2 == parameters.length) {
            Class<?> requestCls = parameters[0];
            Class<?> responseCls = parameters[1];
            if (HttpServerRequest.class == requestCls && HttpServerResponse.class == responseCls) {
                valid = true;
            }
        }
        return valid;
    }
}

