/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import io.reactivex.Observable;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error.WallDuplicatedException;
import io.vertx.tp.error.WallKeyMissingException;
import io.vertx.up.annotations.Wall;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.exception.zero.DynamicKeyMissingException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.Rampart;
import io.vertx.up.secure.inquire.OstiumAuth;
import io.vertx.up.secure.inquire.PhylumAuth;
import io.vertx.up.uca.marshal.Transformer;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class WallInquirer
implements Inquirer<Set<Cliff>> {
    private static final Annal LOGGER = Annal.get(WallInquirer.class);
    private static final Node<JsonObject> NODE = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final String KEY = "secure";
    private final transient Transformer<Cliff> transformer = (Transformer)Ut.singleton(Rampart.class, (Object[])new Object[0]);

    @Override
    public Set<Cliff> scan(Set<Class<?>> walls) {
        TreeSet<Cliff> wallSet = new TreeSet<Cliff>();
        Set<Class<?>> wallClses = walls.stream().filter(item -> item.isAnnotationPresent(Wall.class)).collect(Collectors.toSet());
        if (!wallClses.isEmpty()) {
            ConcurrentHashMap keys = new ConcurrentHashMap();
            JsonObject config = this.verify(wallClses, keys);
            for (String field : config.fieldNames()) {
                Class cls = (Class)keys.get(field);
                Cliff cliff = (Cliff)this.transformer.transform(config.getJsonObject(field));
                this.mountData(cliff, cls);
                wallSet.add(cliff);
            }
        }
        return wallSet;
    }

    private void mountData(Cliff cliff, Class<?> clazz) {
        this.mountAnno(cliff, clazz);
        if (cliff.isDefined()) {
            OstiumAuth.create(clazz).verify().mount(cliff);
        } else {
            PhylumAuth.create(clazz).verify().mount(cliff);
        }
    }

    private void mountAnno(Cliff cliff, Class<?> clazz) {
        Wall annotation = clazz.getAnnotation(Wall.class);
        cliff.setOrder(((Integer)Ut.invoke((Object)annotation, (String)"order", (Object[])new Object[0])).intValue());
        cliff.setPath((String)Ut.invoke((Object)annotation, (String)"path", (Object[])new Object[0]));
        cliff.setDefined(((Boolean)Ut.invoke((Object)annotation, (String)"define", (Object[])new Object[0])).booleanValue());
    }

    private JsonObject verify(Set<Class<?>> wallClses, ConcurrentMap<String, Class<?>> keysRef) {
        HashSet hashs = new HashSet();
        Observable.fromIterable(wallClses).filter(Objects::nonNull).map(item -> {
            Wall annotation = item.getAnnotation(Wall.class);
            keysRef.put((String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]), (Class<?>)item);
            return this.hashPath((Annotation)annotation);
        }).subscribe(hashs::add).dispose();
        Fn.outUp((hashs.size() != wallClses.size() ? 1 : 0) != 0, (Annal)LOGGER, WallDuplicatedException.class, (Object[])new Object[]{this.getClass(), wallClses.stream().map(Class::getName).collect(Collectors.toSet())});
        JsonObject config = (JsonObject)NODE.read();
        Fn.outUp((!config.containsKey(KEY) ? 1 : 0) != 0, (Annal)LOGGER, DynamicKeyMissingException.class, (Object[])new Object[]{this.getClass(), KEY, config});
        JsonObject hitted = config.getJsonObject(KEY);
        for (String key : keysRef.keySet()) {
            Fn.outUp((null == hitted || !hitted.containsKey(key) ? 1 : 0) != 0, (Annal)LOGGER, WallKeyMissingException.class, (Object[])new Object[]{this.getClass(), key, keysRef.get(key)});
        }
        return hitted;
    }

    private String hashPath(Annotation annotation) {
        Integer order = (Integer)Ut.invoke((Object)annotation, (String)"order", (Object[])new Object[0]);
        String path = (String)Ut.invoke((Object)annotation, (String)"path", (Object[])new Object[0]);
        return Ut.encryptSHA256((String)(order + path));
    }
}

