/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

class Atomic {
    private static final Vertx VERTX;

    Atomic() {
    }

    static Vertx nativeVertx() {
        return VERTX;
    }

    static WorkerExecutor nativeWorker(String name, Integer minutes) {
        return VERTX.createSharedWorkerExecutor(name, 2, (long)minutes.intValue(), TimeUnit.MINUTES);
    }

    static void nativeInit(JsonObject init) {
        String className = init.getString("component");
        Class clazz = Ut.clazz((String)className);
        if (null != clazz) {
            Fn.safeJvm(() -> {
                Method initMethod = clazz.getDeclaredMethod("init", new Class[0]);
                initMethod.invoke(null, new Object[0]);
            });
        }
    }

    static {
        VertxOptions options = new VertxOptions();
        options.setMaxEventLoopExecuteTime(3000000000000L);
        options.setMaxWorkerExecuteTime(3000000000000L);
        options.setBlockedThreadCheckInterval(10000L);
        VERTX = Vertx.vertx((VertxOptions)options);
    }
}

