/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.unity.From;
import io.vertx.up.unity.To;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class Comparer {
    Comparer() {
    }

    static <T, R> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Function<T, R> fnValue, String mergedPojo) {
        ConcurrentHashMap comparedMap = new ConcurrentHashMap<ChangeFlag, List<T>>(){
            {
                this.put(ChangeFlag.DELETE, new ArrayList());
                this.put(ChangeFlag.UPDATE, new ArrayList());
                this.put(ChangeFlag.ADD, new ArrayList());
            }
        };
        if (Objects.isNull(original) || original.isEmpty()) {
            if (Objects.nonNull(current)) {
                ((List)comparedMap.get(ChangeFlag.ADD)).addAll(current);
            }
        } else {
            original.forEach(originalItem -> {
                Object latestItem = Comparer.find(current, originalItem, fnValue);
                if (Objects.isNull(latestItem)) {
                    ((List)comparedMap.get(ChangeFlag.DELETE)).add(originalItem);
                }
            });
            current.forEach(latestItem -> {
                Object previous = Comparer.find(original, latestItem, fnValue);
                if (Objects.isNull(previous)) {
                    ((List)comparedMap.get(ChangeFlag.ADD)).add(latestItem);
                } else {
                    Object updated = Comparer.combine(previous, latestItem, mergedPojo);
                    ((List)comparedMap.get(ChangeFlag.UPDATE)).add(updated);
                }
            });
        }
        return comparedMap;
    }

    private static <T> T combine(T old, T latest, String pojo) {
        if (Objects.isNull(old) && Objects.isNull(latest)) {
            return null;
        }
        if (Objects.isNull(old)) {
            return latest;
        }
        if (Objects.isNull(latest)) {
            return old;
        }
        JsonObject combineJson = Ut.sureJObject((JsonObject)To.toJObject(old, pojo));
        JsonObject latestJson = Ut.sureJObject((JsonObject)To.toJObject(latest, pojo));
        if (latestJson.containsKey("key")) {
            latestJson.remove("key");
        }
        combineJson.mergeIn(latestJson, true);
        Class<?> clazz = latest.getClass();
        return (T)From.fromJson(combineJson, clazz, pojo);
    }

    private static <T, R> T find(List<T> list, T current, Function<T, R> fnValue) {
        if (Objects.isNull(list) || list.isEmpty() || Objects.isNull(current)) {
            return null;
        }
        Object comparedValue = fnValue.apply(current);
        if (Objects.isNull(comparedValue)) {
            return null;
        }
        return list.stream().filter(Objects::nonNull).filter(each -> comparedValue.equals(fnValue.apply(each))).findAny().orElse(null);
    }
}

