/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.component.Dictionary;
import io.vertx.up.commune.exchange.DictConfig;
import io.vertx.up.commune.exchange.DictEpsilon;
import io.vertx.up.commune.exchange.DictFabric;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.adminicle.FieldMapper;
import io.vertx.up.unity.To;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class DictTool {
    private static final ConcurrentMap<Integer, Dictionary> POOL_DICT = new ConcurrentHashMap<Integer, Dictionary>();

    DictTool() {
    }

    static ConcurrentMap<String, DictEpsilon> mapEpsilon(JsonObject epsilonJson) {
        ConcurrentHashMap<String, DictEpsilon> epsilonMap = new ConcurrentHashMap<String, DictEpsilon>();
        if (Ut.notNil((JsonObject)epsilonJson)) {
            epsilonJson.fieldNames().stream().filter(field -> epsilonJson.getValue(field) instanceof JsonObject).forEach(field -> {
                JsonObject fieldData = epsilonJson.getJsonObject(field);
                DictEpsilon epsilon = new DictEpsilon();
                epsilon.fromJson(fieldData);
                epsilonMap.put((String)field, epsilon);
            });
        }
        return epsilonMap;
    }

    static <T> Future<T> dictTo(T record, DictFabric fabric) {
        FieldMapper mapper = new FieldMapper();
        if (record instanceof JsonObject) {
            JsonObject ref = (JsonObject)record;
            return fabric.inTo(ref).compose(processed -> Ux.future(mapper.out(processed, fabric.mapping()))).compose(processed -> Ux.future(processed));
        }
        if (record instanceof JsonArray) {
            JsonArray ref = (JsonArray)record;
            return fabric.inTo(ref).compose(processed -> Ux.future(mapper.out(processed, fabric.mapping()))).compose(processed -> Ux.future(processed));
        }
        return Ux.future(record);
    }

    static Future<ConcurrentMap<String, JsonArray>> dictCalc(DictConfig dict, MultiMap paramMap) {
        if (Objects.isNull(dict)) {
            return To.future(new ConcurrentHashMap());
        }
        ConcurrentHashMap dictData = new ConcurrentHashMap();
        if (dict.valid()) {
            Class dictCls = dict.getComponent();
            if (Ut.isImplement((Class)dictCls, Dictionary.class)) {
                Dictionary dictStub = (Dictionary)Fn.pool(POOL_DICT, (Object)dict.hashCode(), () -> (Dictionary)Ut.instance((Class)dictCls, (Object[])new Object[0]));
                return dictStub.fetchAsync(paramMap, dict.getSource());
            }
            return To.future(dictData);
        }
        return To.future(dictData);
    }
}

