/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.tp.plugin.shared.MapInfix;
import io.vertx.tp.plugin.shared.SharedClient;
import io.vertx.up.atom.Kv;
import io.vertx.up.exception.web._500PoolInternalException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.To;
import java.util.Set;

public class UxPool {
    private static final Annal LOGGER = Annal.get(UxPool.class);
    private final transient String name;
    private final transient SharedClient client;

    UxPool() {
        this.name = MapInfix.getDefaultName();
        this.client = MapInfix.getClient();
    }

    UxPool(String name) {
        this.name = name;
        this.client = MapInfix.getClient().switchClient(name);
    }

    public <K, V> Future<Kv<K, V>> put(K key, V value) {
        return Fn.thenGeneric(future -> this.client.put(key, value, res -> {
            LOGGER.debug("( Shared ) key = {0}, value = {1} has been put into {2}.", new Object[]{key, value, this.name});
            Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "put"));
        }));
    }

    public <K, V> Future<Kv<K, V>> put(K key, V value, int expiredSecs) {
        return Fn.thenGeneric(future -> this.client.put(key, value, expiredSecs, res -> {
            LOGGER.debug("( Shared ) key = {0}, value = {1} has been put into {2} to keep {3} seconds", new Object[]{key, value, this.name, String.valueOf(expiredSecs)});
            Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "put"));
        }));
    }

    public <K, V> Future<Kv<K, V>> remove(K key) {
        return Fn.thenGeneric(future -> this.client.remove(key, res -> {
            LOGGER.debug("( Shared ) key = {0} has been removed from pool name = {2}.", new Object[]{key, this.name});
            Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "remove"));
        }));
    }

    public <K, V> Future<V> get(K key) {
        return Fn.thenGeneric(future -> this.client.get(key, res -> {
            LOGGER.debug("( Shared ) key = {0} has been picked from {1}, mode = {2}", new Object[]{key, this.name, false});
            Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "get"));
        }));
    }

    public <K, V> Future<V> get(K key, boolean once) {
        return Fn.thenGeneric(future -> this.client.get(key, once, res -> {
            LOGGER.debug("( Shared ) key = {0} has been picked from {1}, mode = {2}", new Object[]{key, this.name, once});
            Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "get"));
        }));
    }

    public Future<Boolean> clear() {
        return Fn.thenGeneric(future -> this.client.clear((Handler<AsyncResult<Boolean>>)((Handler)res -> {
            LOGGER.debug("( Shared ) pool = {0} has been cleared successfully.", new Object[]{this.name});
            Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "clear"));
        })));
    }

    public Future<Integer> size() {
        return Fn.thenGeneric(future -> this.client.size((Handler<AsyncResult<Integer>>)((Handler)res -> Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "size")))));
    }

    public Future<Set<String>> keys() {
        return Fn.thenGeneric(future -> this.client.keys(res -> Fn.thenGeneric((Object)res, (Promise)future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "keys"))));
    }
}

