/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.json.JsonObject;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;

class Where {
    Where() {
    }

    static JsonObject whereDay(JsonObject filters, String field, Instant instant) {
        if (Ut.notNil((String)field) && Objects.nonNull(instant)) {
            LocalDateTime current = Ut.toDateTime((Instant)instant);
            LocalDateTime begin = LocalDateTime.of(current.toLocalDate(), LocalTime.MIN);
            LocalDateTime end = LocalDateTime.of(current.toLocalDate(), LocalTime.MAX);
            JsonObject condition = new JsonObject();
            condition.put(field + ",<", Ut.parse((LocalDateTime)end).toInstant());
            condition.put(field + ",>", Ut.parse((LocalDateTime)begin).toInstant());
            condition.put("", Boolean.TRUE);
            filters.put("$" + field, condition);
        }
        return filters;
    }

    static JsonObject whereAnd() {
        return new JsonObject().put("", Boolean.TRUE);
    }

    static JsonObject whereOr() {
        return new JsonObject().put("", Boolean.FALSE);
    }
}

