/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.verticle;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.annotations.Worker;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.uca.invoker.Invoker;
import io.vertx.up.uca.invoker.InvokerUtil;
import io.vertx.up.uca.invoker.JetSelector;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

@Worker
public class ZeroHttpWorker
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpWorker.class);
    private static final Set<Receipt> RECEIPTS = ZeroAnno.getReceipts();
    private static final ConcurrentMap<Integer, Invoker> INVOKER_MAP = new ConcurrentHashMap<Integer, Invoker>();
    private static final AtomicBoolean LOGGED = new AtomicBoolean(Boolean.FALSE);

    public void start() {
        EventBus bus = this.vertx.eventBus();
        for (Receipt receipt : RECEIPTS) {
            String address = receipt.getAddress();
            Object reference = receipt.getProxy();
            Method method = receipt.getMethod();
            InvokerUtil.verifyArgs(method, ((Object)((Object)this)).getClass());
            Class<?>[] params = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            Class<?> paramCls = params[0];
            Invoker invoker = JetSelector.select(returnType, paramCls);
            invoker.ensure(returnType, paramCls);
            INVOKER_MAP.put(receipt.hashCode(), invoker);
            Fn.safeJvm(() -> Fn.safeNull(() -> bus.consumer(address, message -> {
                if (method.isAnnotationPresent(Ipc.class)) {
                    invoker.next(reference, method, (Message<Envelop>)message, this.vertx);
                } else {
                    try {
                        invoker.invoke(reference, method, (Message<Envelop>)message);
                    }
                    catch (Throwable ex) {
                        message.fail(0, ex.getMessage());
                    }
                }
            }), (Object[])new Object[]{address, reference, method}), (Annal)LOGGER);
        }
        if (!LOGGED.getAndSet(Boolean.TRUE)) {
            ConcurrentHashMap<Class, Set> outputMap = new ConcurrentHashMap<Class, Set>();
            INVOKER_MAP.forEach((key, value) -> {
                if (outputMap.containsKey(value.getClass())) {
                    ((Set)outputMap.get(value.getClass())).add(key);
                } else {
                    outputMap.put(value.getClass(), new HashSet());
                }
            });
            outputMap.forEach((key, value) -> LOGGER.info("( Invoker ) Zero system selected {0} as invoker,the metadata receipt hash code = {1}, invoker size = {2}.", new Object[]{key, Ut.toString((Object)value), String.valueOf(value.size())}));
        }
    }
}

