package io.vertx.up.uca.monitor.meansure;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.ID;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

/**
 * @author <a href="http://www.origin-x.cn">Lang</a>
 */
public class QuotaConnect {
    private static final Node<JsonObject> node = Ut.instance(ZeroUniform.class);
    private static final Annal LOGGER = Annal.get(QuotaConnect.class);
    private static final String PATH;
    /*
     * Default Quota that will be mounted to health monitor
     *
     * - session: SessionMonitor
     * - instance: Verticle Monitor
     */
    static ConcurrentMap<String, Function<Vertx, Quota>> REGISTRY_CLS = new ConcurrentHashMap<String, Function<Vertx, Quota>>() {
        {
            this.put("session", SessionQuota::new);
            this.put("instance", VerticleQuota::new);
        }
    };

    static {
        final JsonObject config = node.read();
        final String secure = Ut.visitString(config, "monitor", "secure");
        if (Ut.isNil(secure)) {
            PATH = ID.Addr.MONITOR_PATH;
        } else {
            PATH = secure + ID.Addr.MONITOR_PATH;
        }
        final JsonArray quotas = Ut.visitJArray(config, "monitor", "quota");
        LOGGER.info("[ Hc ] Configured size: {0}, root path: {1}",
            String.valueOf(quotas.size()), PATH);
        /*
         * Mount to REGISTRY_CLS
         */
        final StringBuilder message = new StringBuilder("[ Hc ] Initialize components: ");
        Ut.itJArray(quotas).forEach(item -> {
            final String path = item.getString("path", null);
            final String componentName = item.getString("component");
            if (Ut.notNil(path) && !REGISTRY_CLS.containsKey(path)) {
                final Class<?> componentCls = Ut.clazz(componentName, null);
                if (Objects.nonNull(componentCls)) {
                    REGISTRY_CLS.put(path, (vertx) -> Ut.instance(componentCls, vertx));
                    message.append(MessageFormat.format("\n\t{0} = {1}", path,
                        componentCls.getName()));
                }
            }
        });
        message.append("\n");
        LOGGER.info(message.toString());
    }

    public static String routePath() {
        return PATH;
    }
}
