/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.quiz;

import io.vertx.core.Future;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.quiz.AsyncBase;
import io.vertx.up.atom.Kv;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class JooqBase
extends AsyncBase {
    @Rule
    public final RunTestOnContext rule = new RunTestOnContext(OPTIONS);

    public UxJooq getDao() {
        return null;
    }

    public <T> void asyncJooq(TestContext context, Supplier<Future<T>> supplier, Consumer<T> function) {
        this.asyncJooq(context, supplier, function, this::getDao);
    }

    private <T> void asyncJooq(TestContext context, Supplier<Future<T>> supplier, Consumer<T> consumer, Supplier<UxJooq> daoSupplier) {
        UxJooq jooq = daoSupplier.get();
        if (null != jooq) {
            Future<T> future = supplier.get();
            Fn.onTest((TestContext)context, future, consumer);
        }
    }

    public <T> void notNull(T entity, TestContext context) {
        context.assertNotNull(entity);
        Annal.get(((Object)((Object)this)).getClass()).debug("[ Sim ] {0}", new Object[]{entity.getClass()});
    }

    protected void fetchOneAsync(TestContext context, Class<?> clazzDao, String pojo, Object ... args) {
        ArrayList<Kv> kvs = new ArrayList<Kv>();
        int length = args.length / 2;
        for (int idx = 0; idx < length; ++idx) {
            int index = idx * 2;
            String key = args[index].toString();
            Object value = args[index + 1];
            kvs.add(Kv.create((Object)key, (Object)value));
        }
        kvs.forEach(kv -> {
            UxJooq jooq = Ux.Jooq.on(clazzDao);
            if (null != pojo) {
                jooq = jooq.on(pojo);
            }
            this.async(context, jooq.fetchOneAsync((String)kv.getKey(), kv.getValue()), arg_0 -> ((TestContext)context).assertNotNull(arg_0));
        });
    }
}

