/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.session;

import io.vertx.core.Vertx;
import io.vertx.tp.plugin.session.SessionClient;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.fn.Fn;
import io.vertx.up.plugin.Infix;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin
public class SessionInfix
implements Infix {
    private static final String NAME = "ZERO_SESSION_POOL";
    private static final ConcurrentMap<String, SessionClient> CLIENTS = new ConcurrentHashMap<String, SessionClient>();

    private static void initInternal(Vertx vertx, String name) {
        SessionInfix.getOrCreate(vertx, name);
    }

    public static void init(Vertx vertx) {
        SessionInfix.initInternal(vertx, NAME);
    }

    public static SessionClient getClient() {
        return (SessionClient)CLIENTS.get(NAME);
    }

    public static SessionClient getOrCreate(Vertx vertx) {
        return SessionInfix.getOrCreate(vertx, NAME);
    }

    private static SessionClient getOrCreate(Vertx vertx, String name) {
        SessionClient client = (SessionClient)CLIENTS.get(name);
        if (Objects.isNull(client)) {
            return (SessionClient)Fn.pool(CLIENTS, (Object)name, () -> (SessionClient)Infix.init((String)"session", config -> SessionClient.createShared(vertx, config), SessionInfix.class));
        }
        return client;
    }

    public SessionClient get() {
        return SessionInfix.getClient();
    }
}

