/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shared;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.SharedData;
import io.vertx.tp.plugin.shared.SharedClient;
import io.vertx.up.atom.Kv;
import io.vertx.up.exception.web._501SharedDataModeException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedClientImpl<K, V>
implements SharedClient<K, V> {
    private static final Annal LOGGER = Annal.get(SharedClientImpl.class);
    private static final ConcurrentMap<String, SharedClient> CLIENTS = new ConcurrentHashMap<String, SharedClient>();
    private final transient Vertx vertx;
    private transient LocalMap<K, V> syncMap;
    private transient AsyncMap<K, V> asyncMap;
    private transient boolean isAsync;

    SharedClientImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    SharedClient create(JsonObject config, String name) {
        return (SharedClient)Fn.pool(CLIENTS, (Object)name, () -> {
            boolean async = null != config && config.containsKey("async") ? config.getBoolean("async") : Boolean.FALSE;
            if (async) {
                this.createAsync(name, (Handler<AsyncResult<SharedClient>>)((Handler)res -> {
                    this.asyncMap = ((SharedClient)res.result()).fetchAsync();
                }));
            } else {
                this.createSync(name);
            }
            return this;
        });
    }

    @Override
    public AsyncMap<K, V> fetchAsync() {
        return this.asyncMap;
    }

    @Override
    public LocalMap<K, V> fetchSync() {
        return this.syncMap;
    }

    @Override
    public SharedClient<K, V> switchClient(String name) {
        SharedClient client = this.isAsync ? new SharedClientImpl<K, V>(this.vertx).create(new JsonObject().put("async", (Object)Boolean.TRUE), name) : new SharedClientImpl<K, V>(this.vertx).create(new JsonObject().put("async", (Object)Boolean.FALSE), name);
        return client;
    }

    private SharedClient createSync(String name) {
        SharedData sd = this.vertx.sharedData();
        this.syncMap = sd.getLocalMap(name);
        LOGGER.info("( Sync ) You are using sync mode to create LocalMap: {0}", new Object[]{String.valueOf(this.syncMap.hashCode())});
        this.isAsync = false;
        return this;
    }

    private SharedClient createAsync(String name, Handler<AsyncResult<SharedClient>> handler) {
        SharedData sd = this.vertx.sharedData();
        LOGGER.info("( Async ) You are using async mode to create AsyncMap, begin to singleton.", new Object[0]);
        sd.getAsyncMap(name, res -> {
            if (res.succeeded()) {
                this.asyncMap = (AsyncMap)res.result();
                LOGGER.info("( Async ) Your AsyncMap {0} has been created successfully, you can use it now.", new Object[]{String.valueOf(this.asyncMap.hashCode())});
                this.isAsync = true;
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    @Override
    public Kv<K, V> put(K key, V value) {
        this.ensure(false);
        Object reference = this.syncMap.get(key);
        Fn.safeSemi((null == reference ? 1 : 0) != 0, (Annal)LOGGER, () -> this.syncMap.put(key, value), () -> this.syncMap.replace(key, value));
        return Kv.create(key, value);
    }

    @Override
    public Kv<K, V> put(K key, V value, int seconds) {
        Kv<K, V> result = this.put(key, value);
        LOGGER.info("( Timer ) You called timer put method, the key \"{0}\" will be expired in {1} seconds", new Object[]{String.valueOf(key), String.valueOf(seconds)});
        this.vertx.setTimer((long)(seconds * 1000), id -> {
            V existing = this.get(key);
            if (Objects.nonNull(existing)) {
                LOGGER.info("( Timer ) The key \"{0}\" refered data has been removed.", new Object[]{String.valueOf(key)});
                this.remove(key);
            } else {
                LOGGER.info("( Timer ) The key \"{0}\" does not exist, it has been removed before.", new Object[]{String.valueOf(key)});
            }
        });
        return result;
    }

    @Override
    public SharedClient<K, V> put(K key, V value, Handler<AsyncResult<Kv<K, V>>> handler) {
        this.ensure(true);
        this.asyncMap.get(key, res -> {
            if (res.succeeded()) {
                Object reference = res.result();
                Fn.safeSemi((null == reference ? 1 : 0) != 0, (Annal)LOGGER, () -> this.asyncMap.put(key, value, added -> {
                    if (added.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)Kv.create((Object)key, (Object)value)));
                    }
                }), () -> this.asyncMap.replace(key, value, replaced -> {
                    if (replaced.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)Kv.create((Object)key, (Object)value)));
                    }
                }));
            }
        });
        return this;
    }

    @Override
    public SharedClient<K, V> put(K key, V value, int seconds, Handler<AsyncResult<Kv<K, V>>> handler) {
        SharedClient<K, V> reference = this.put(key, value, handler);
        LOGGER.info("( Timer ) You called timer put method, the key \"{0}\" will be expired in {1} seconds", new Object[]{String.valueOf(key), String.valueOf(seconds)});
        this.vertx.setTimer((long)(seconds * 1000), id -> this.remove(key, res -> LOGGER.info("( Timer ) The key \"{0}\" refered data has been removed.", new Object[]{key})));
        return reference;
    }

    @Override
    public Kv<K, V> remove(K key) {
        this.ensure(false);
        Object removed = this.syncMap.remove(key);
        return Kv.create(key, (Object)removed);
    }

    @Override
    public V get(K key) {
        this.ensure(false);
        return (V)this.syncMap.get(key);
    }

    @Override
    public boolean clear() {
        this.syncMap.clear();
        return true;
    }

    @Override
    public V get(K key, boolean once) {
        V value = this.get(key);
        if (once) {
            this.remove(key);
        }
        return value;
    }

    @Override
    public SharedClient<K, V> remove(K key, Handler<AsyncResult<Kv<K, V>>> handler) {
        this.ensure(true);
        this.asyncMap.remove(key, res -> {
            if (res.succeeded()) {
                Object reference = res.result();
                handler.handle((Object)Future.succeededFuture((Object)Kv.create((Object)key, (Object)reference)));
            }
        });
        return this;
    }

    @Override
    public SharedClient<K, V> get(K key, Handler<AsyncResult<V>> handler) {
        this.ensure(true);
        this.asyncMap.get(key, handler);
        return this;
    }

    @Override
    public SharedClient<K, V> get(K key, boolean once, Handler<AsyncResult<V>> handler) {
        SharedClient<K, V> reference = this.get(key, handler);
        if (once) {
            this.asyncMap.remove(key, handler);
        }
        return reference;
    }

    @Override
    public SharedClient<K, V> clear(Handler<AsyncResult<Boolean>> handler) {
        this.asyncMap.clear(result -> handler.handle((Object)Future.succeededFuture((Object)Boolean.TRUE)));
        return this;
    }

    private void ensure(boolean expected) {
        Fn.outWeb((this.isAsync != expected ? 1 : 0) != 0, (Annal)LOGGER, _501SharedDataModeException.class, (Object[])new Object[]{this.getClass(), this.isAsync});
    }

    @Override
    public SharedClient<K, V> size(Handler<AsyncResult<Integer>> handler) {
        this.asyncMap.size(handler);
        return this;
    }

    @Override
    public SharedClient<K, V> keys(Handler<AsyncResult<Set<K>>> handler) {
        this.asyncMap.keys(handler);
        return this;
    }

    @Override
    public int size() {
        return this.syncMap.size();
    }

    @Override
    public Set<K> keys() {
        return this.syncMap.keySet();
    }
}

