/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom.worker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ClassDeserializer;
import com.fasterxml.jackson.databind.ClassSerializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Off;
import io.vertx.up.annotations.On;
import io.vertx.up.eon.em.JobStatus;
import io.vertx.up.eon.em.JobType;
import io.vertx.up.exception.web._501JobOnMissingException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.log.Debugger;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class Mission
implements Serializable {
    private static final Annal LOGGER = Annal.get(Mission.class);
    private JobStatus status = JobStatus.STARTING;
    private String name;
    private JobType type;
    private String code;
    private String comment;
    private boolean readOnly;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject metadata = new JsonObject();
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject additional = new JsonObject();
    @JsonIgnore
    private Instant instant = Instant.now();
    private long duration = -1L;
    private long threshold = -1L;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private Class<?> income;
    private String incomeAddress;
    @JsonSerialize(using=ClassSerializer.class)
    @JsonDeserialize(using=ClassDeserializer.class)
    private Class<?> outcome;
    private String outcomeAddress;
    @JsonIgnore
    private Object proxy;
    @JsonIgnore
    private Method on;
    @JsonIgnore
    private Method off;

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobType getType() {
        return this.type;
    }

    public void setType(JobType type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JsonObject metadata) {
        this.metadata = metadata;
    }

    public JsonObject getAdditional() {
        return this.additional;
    }

    public void setAdditional(JsonObject additional) {
        this.additional = additional;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public void setInstant(Instant instant) {
        this.instant = instant;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public Method getOn() {
        return this.on;
    }

    public void setOn(Method on) {
        this.on = on;
    }

    public Method getOff() {
        return this.off;
    }

    public void setOff(Method off) {
        this.off = off;
    }

    public Class<?> getIncome() {
        return this.income;
    }

    public void setIncome(Class<?> income) {
        this.income = income;
    }

    public String getIncomeAddress() {
        return this.incomeAddress;
    }

    public void setIncomeAddress(String incomeAddress) {
        this.incomeAddress = incomeAddress;
    }

    public Class<?> getOutcome() {
        return this.outcome;
    }

    public void setOutcome(Class<?> outcome) {
        this.outcome = outcome;
    }

    public String getOutcomeAddress() {
        return this.outcomeAddress;
    }

    public void setOutcomeAddress(String outcomeAddress) {
        this.outcomeAddress = outcomeAddress;
    }

    public Mission connect(Class<?> clazz) {
        Object proxy = Ut.singleton(clazz, (Object[])new Object[0]);
        if (Objects.nonNull(proxy)) {
            this.proxy = proxy;
            this.on = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(On.class)).findFirst().orElse(null);
            Fn.out((null == this.on ? 1 : 0) != 0, _501JobOnMissingException.class, (Object[])new Object[]{this.getClass(), clazz.getName()});
            On on = this.on.getAnnotation(On.class);
            this.incomeAddress = this.invoke((Annotation)on, "address", this::getIncomeAddress);
            this.income = this.invoke((Annotation)on, "income", this::getIncome);
            if (Ut.isNil((String)this.incomeAddress)) {
                this.incomeAddress = null;
            }
            this.off = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Off.class)).findFirst().orElse(null);
            if (Objects.nonNull(this.off)) {
                Off out = this.off.getAnnotation(Off.class);
                this.outcomeAddress = this.invoke((Annotation)out, "address", this::getOutcomeAddress);
                this.outcome = this.invoke((Annotation)out, "outcome", this::getOutcome);
                if (Ut.isNil((String)this.outcomeAddress)) {
                    this.outcomeAddress = null;
                }
            }
            if (Debugger.onJobBoot()) {
                LOGGER.info("[ Job ] Current job `{0}` has defined @Off method.", new Object[]{this.getCode()});
            }
        }
        return this;
    }

    private <T> T invoke(Annotation annotation, String annotationMethod, Supplier<T> supplier) {
        Object reference = supplier.get();
        if (Objects.isNull(reference)) {
            reference = Ut.invoke((Object)annotation, (String)annotationMethod, (Object[])new Object[0]);
        }
        return reference;
    }

    public String toString() {
        return "Mission{status=" + this.status + ", name='" + this.name + "', readOnly='" + this.readOnly + "', type=" + this.type + ", code='" + this.code + "', comment='" + this.comment + "', metadata=" + this.metadata + ", additional=" + this.additional + ", instant=" + this.instant + ", duration=" + this.duration + ", threshold=" + this.threshold + ", income=" + this.income + ", incomeAddress='" + this.incomeAddress + "', outcome=" + this.outcome + ", outcomeAddress='" + this.outcomeAddress + "', proxy=" + this.proxy + ", on=" + this.on + ", off=" + this.off + "}";
    }
}

