/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.Act;
import io.vertx.up.commune.ActMapping;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.BiMapping;
import io.vertx.up.commune.exchange.BiTree;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;

public class ActOut
extends ActMapping
implements Serializable {
    private static final Annal LOGGER = Annal.get(ActOut.class);
    private final transient Envelop envelop;
    private transient String identifier;

    ActOut(Object data, HttpStatusCode statusCode) {
        this.envelop = Envelop.success(data, statusCode);
    }

    ActOut(Object data) {
        this.envelop = Envelop.success(data, HttpStatusCode.OK);
    }

    ActOut(Throwable ex) {
        this.envelop = Envelop.failure(ex);
    }

    public static Future<ActOut> empty() {
        return Ux.future(Act.empty());
    }

    public static Future<ActOut> future(Boolean result) {
        return Ux.future(Act.response(result));
    }

    public static Future<ActOut> future(Buffer buffer) {
        return Ux.future(Act.response(buffer));
    }

    public static Future<ActOut> future(Throwable ex) {
        return Ux.future(Act.response(ex));
    }

    public static Future<ActOut> future(JsonObject data) {
        return Ux.future(Act.response(data));
    }

    public static Future<ActOut> future(JsonObject data, String identifier) {
        return Ux.future(Act.response(data).bind(identifier));
    }

    public static Future<ActOut> future(JsonArray dataArray) {
        return Ux.future(Act.response(dataArray));
    }

    public static Future<ActOut> future(JsonArray dataArray, String identifier) {
        return Ux.future(Act.response(dataArray).bind(identifier));
    }

    public static Future<ActOut> future(Record[] records) {
        return Ux.future(Act.response(records));
    }

    public static Future<ActOut> future(Record[] records, String identifier) {
        return Ux.future(Act.response(records).bind(identifier));
    }

    public static Future<ActOut> future(Record record) {
        return Ux.future(Act.response(record));
    }

    public static Future<ActOut> future(Record record, String identifier) {
        return Ux.future(Act.response(record).bind(identifier));
    }

    private ActOut bind(String identifier) {
        if (Ut.notNil((String)identifier)) {
            this.identifier = identifier;
        }
        return this;
    }

    public Envelop envelop(BiTree mapping) {
        Object response = this.envelop.data();
        if (response instanceof JsonObject || response instanceof JsonArray) {
            if (this.isAfter(mapping)) {
                BiMapping biMapping;
                if (Objects.isNull(this.identifier)) {
                    biMapping = mapping.child();
                } else {
                    biMapping = mapping.child(this.identifier);
                    if (!biMapping.isEmpty()) {
                        LOGGER.info("identifier `{0}`, extract child mapping. {1}", new Object[]{this.identifier, biMapping.toString()});
                    }
                }
                HttpStatusCode status = this.envelop.status();
                if (response instanceof JsonObject) {
                    JsonObject normalized = this.mapper().out((JsonObject)response, biMapping);
                    return Envelop.success(normalized, status).from(this.envelop);
                }
                JsonArray normalized = new JsonArray();
                Ut.itJArray((JsonArray)((JsonArray)response)).map(item -> this.mapper().out(item, biMapping)).forEach(arg_0 -> ((JsonArray)normalized).add(arg_0));
                return Envelop.success(normalized, status).from(this.envelop);
            }
            return this.envelop;
        }
        return this.envelop;
    }
}

