/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.commune;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.up.commune.Assist;
import io.vertx.up.commune.envelop.Rib;
import io.vertx.up.commune.secure.Acl;
import io.vertx.up.eon.ID;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._000HttpWebException;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.IndexExceedException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Envelop
implements Serializable {
    private final HttpStatusCode status;
    private final WebException error;
    private final JsonObject data;
    private final Assist assist = new Assist();
    private final JsonObject cachedJwt = new JsonObject();
    private String key;
    private Acl acl;

    private <T> Envelop(T data, HttpStatusCode status) {
        this.data = Rib.input(data);
        this.error = null;
        this.status = status;
    }

    private Envelop(WebException error) {
        this.status = error.getStatus();
        this.error = error;
        this.data = error.toJson();
    }

    public static Envelop ok() {
        return new Envelop(null, HttpStatusCode.NO_CONTENT);
    }

    public static Envelop okJson() {
        return new Envelop(new JsonObject(), HttpStatusCode.OK);
    }

    public static <T> Envelop success(T entity) {
        return new Envelop(entity, HttpStatusCode.OK);
    }

    public static <T> Envelop success(T entity, HttpStatusCode status) {
        return new Envelop(entity, status);
    }

    public static Envelop failure(String message) {
        return new Envelop(new _500InternalServerException(Envelop.class, message));
    }

    public static Envelop failure(Throwable ex) {
        if (ex instanceof WebException) {
            return Envelop.failure((WebException)ex);
        }
        if (ex instanceof HttpException) {
            Throwable actual = ex.getCause();
            if (Objects.isNull(actual)) {
                return new Envelop(new _000HttpWebException(Envelop.class, (HttpException)ex));
            }
            return Envelop.failure(actual);
        }
        return new Envelop(new _500InternalServerException(Envelop.class, ex.getMessage()));
    }

    public static Envelop failure(WebException error) {
        return new Envelop(Rib.normalize(error));
    }

    public boolean valid() {
        return null == this.error;
    }

    public WebException error() {
        return this.error;
    }

    public <T> T data() {
        return Rib.get(this.data);
    }

    public JsonObject body() {
        return Rib.getBody(this.data);
    }

    public <T> T data(Class<T> clazz) {
        return Rib.get(this.data, clazz);
    }

    public <T> T data(Integer argIndex, Class<T> clazz) {
        Fn.outUp((!Rib.isIndex(argIndex) ? 1 : 0) != 0, IndexExceedException.class, (Object[])new Object[]{this.getClass(), argIndex});
        return Rib.get(this.data, clazz, argIndex);
    }

    public void value(String field, Object value) {
        Rib.set(this.data, field, value, null);
    }

    public void value(Integer argIndex, String field, Object value) {
        Rib.set(this.data, field, value, argIndex);
    }

    public void valueOn(String field, Object value) {
        if (Objects.nonNull(this.data)) {
            this.data.put(field, value);
        }
    }

    public String outString() {
        return this.outJson().encode();
    }

    public JsonObject outJson() {
        return Rib.outJson(this.data, this.error);
    }

    public Buffer outBuffer() {
        return Rib.outBuffer(this.data, this.error);
    }

    public HttpStatusCode status() {
        return this.status;
    }

    public Envelop key(String key) {
        this.key = key;
        return this;
    }

    public Envelop acl(Acl acl) {
        this.acl = acl;
        return this;
    }

    public Acl acl() {
        return this.acl;
    }

    public String key() {
        return this.key;
    }

    private void reference(Consumer<JsonObject> consumer) {
        JsonObject reference = Rib.getBody(this.data);
        if (Objects.nonNull(reference)) {
            consumer.accept(reference);
        }
    }

    public void onProjection(JsonArray projection) {
        this.reference(reference -> Rib.projection(reference, projection, false));
    }

    public void inProjection(JsonArray projection) {
        this.reference(reference -> Rib.projection(reference, projection, true));
    }

    public void onCriteria(JsonObject criteria) {
        this.reference(reference -> Rib.criteria(reference, criteria, false));
    }

    public void inCriteria(JsonObject criteria) {
        this.reference(reference -> Rib.criteria(reference, criteria, true));
    }

    public <T> T context(String key, Class<T> clazz) {
        return this.assist.getContextData(key, clazz);
    }

    public String identifier(String field) {
        return this.assist.principal(field);
    }

    public MultiMap headers() {
        return this.assist.headers();
    }

    public JsonObject headersX() {
        JsonObject headerData = new JsonObject();
        this.assist.headers().names().stream().filter(field -> field.startsWith("X-") || field.startsWith("X-".toLowerCase(Locale.getDefault()))).forEach(field -> {
            String found = ID.Header.PARAM_MAP.keySet().stream().filter(field::equalsIgnoreCase).findFirst().map(ID.Header.PARAM_MAP::get).orElse(null);
            if (Ut.notNil((String)found)) {
                headerData.put(found, (Object)this.assist.headers().get(field));
            }
        });
        return headerData;
    }

    public void headers(MultiMap headers) {
        this.assist.headers(headers);
    }

    public Session session() {
        return this.assist.session();
    }

    public void session(Session session) {
        this.assist.session(session);
    }

    public String uri() {
        return this.assist.uri();
    }

    public void uri(String uri) {
        this.assist.uri(uri);
    }

    public HttpMethod method() {
        return this.assist.method();
    }

    public void method(HttpMethod method) {
        this.assist.method(method);
    }

    public void content(Map<String, Object> data) {
        this.assist.context(data);
    }

    public Envelop bind(RoutingContext context) {
        this.assist.bind(context);
        HttpServerRequest request = context.request();
        this.assist.headers(request.headers());
        this.assist.uri(request.uri());
        this.assist.method(request.method());
        this.assist.session(context.session());
        this.assist.user(context.user());
        this.assist.context(context.data());
        return this;
    }

    public RoutingContext context() {
        return this.assist.reference();
    }

    public Envelop to(Envelop to) {
        if (Objects.isNull(to)) {
            return to;
        }
        to.method(this.method());
        to.uri(this.uri());
        to.user(this.user());
        to.session(this.session());
        to.headers(this.headers());
        to.acl(this.acl);
        to.key(this.key);
        return to;
    }

    public Envelop from(Envelop from) {
        if (Objects.nonNull(from)) {
            this.method(from.method());
            this.uri(from.uri());
            this.user(from.user());
            this.session(from.session());
            this.headers(from.headers());
            this.acl(from.acl());
            this.key(from.key());
        }
        return this;
    }

    public String userId() {
        return Ux.keyUser(this.user());
    }

    public User user() {
        return this.assist.user();
    }

    public void user(User user) {
        this.assist.user(user);
    }

    public String token() {
        return this.assist.principal("access_token");
    }

    public String token(String field) {
        if (Ut.isNil((JsonObject)this.cachedJwt)) {
            String jwt = this.assist.principal("access_token");
            JsonObject user = Ux.Jwt.extract(jwt);
            this.cachedJwt.mergeIn(user, true);
        }
        return this.cachedJwt.getString(field);
    }

    public String toString() {
        return "Envelop{status=" + this.status + ", error=" + this.error + ", data=" + this.data + ", assist=" + this.assist.toString() + ", key='" + this.key + "'}";
    }
}

