/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.extension.pointer;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

class Plugin {
    private static final transient Node<JsonObject> UNIFORM;
    private static final transient JsonObject PLUGIN_CONFIG;
    private static final Annal LOGGER;

    Plugin() {
    }

    static void mountPlugin(String key, BiConsumer<Class<?>, JsonObject> consumer) {
        Plugin.mountPlugin(key, null, (pluginCls, config) -> {
            consumer.accept((Class<?>)pluginCls, (JsonObject)config);
            return Ux.future(Envelop.ok());
        });
    }

    static Future<Envelop> mountPlugin(String key, Envelop envelop, BiFunction<Class<?>, JsonObject, Future<Envelop>> function) {
        JsonObject metadata;
        Class pluginCls;
        if (PLUGIN_CONFIG.containsKey(key) && Objects.nonNull(pluginCls = Ut.clazz((String)(metadata = PLUGIN_CONFIG.getJsonObject(key)).getString("component")))) {
            JsonObject config = metadata.getJsonObject("config");
            try {
                return function.apply(pluginCls, config);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                LOGGER.warn("Plugin Extension Failure: {0}, class = {1}", new Object[]{ex.getMessage(), pluginCls});
                return Ux.future(envelop);
            }
        }
        return Ux.future(envelop);
    }

    static {
        JsonObject pluginConfig;
        UNIFORM = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
        PLUGIN_CONFIG = new JsonObject();
        LOGGER = Annal.get(Plugin.class);
        JsonObject uniform = (JsonObject)UNIFORM.read();
        if (uniform.containsKey("extension") && Objects.nonNull(pluginConfig = uniform.getJsonObject("extension"))) {
            PLUGIN_CONFIG.mergeIn(pluginConfig);
        }
    }
}

