/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.options.DynamicVisitor;
import io.vertx.up.uca.options.ServerVisitor;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;

public class ZeroHeart {
    private static final Annal LOGGER = Annal.get(ZeroHeart.class);
    private static final String INIT = "init";
    private static final Node<JsonObject> VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);

    public static void init() {
        JsonObject config = (JsonObject)VISITOR.read();
        if (config.containsKey(INIT)) {
            JsonArray initArray = config.getJsonArray(INIT);
            Ut.itJArray((JsonArray)initArray, (init, index) -> Ux.nativeInit(init));
        }
    }

    public static boolean isShared() {
        JsonObject options = (JsonObject)VISITOR.read();
        return options.containsKey("shared");
    }

    public static boolean isSession() {
        JsonObject options = (JsonObject)VISITOR.read();
        return options.containsKey("session");
    }

    public static boolean isEtcd() {
        JsonObject options = (JsonObject)VISITOR.read();
        return options.containsKey("etcd");
    }

    public static boolean isCache() {
        JsonObject options = (JsonObject)VISITOR.read();
        return options.containsKey("cache");
    }

    public static boolean isGateway() {
        HashSet apiScanned = new HashSet();
        Fn.outUp(() -> {
            ServerVisitor visitor = (ServerVisitor)Ut.singleton(DynamicVisitor.class, (Object[])new Object[0]);
            apiScanned.addAll(((ConcurrentMap)visitor.visit(new String[]{ServerType.API.toString()})).keySet());
        }, (Annal)LOGGER);
        return !apiScanned.isEmpty();
    }
}

