/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime.deployment;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Agent;
import io.vertx.up.annotations.Worker;
import io.vertx.up.atom.agent.Arrange;
import io.vertx.up.eon.em.DeployMode;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.deployment.Rotate;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DeployRotate
implements Rotate {
    private static final Annal LOGGER = Annal.get(DeployRotate.class);
    private static final ConcurrentMap<Class<?>, JsonObject> OPTIONS = new ConcurrentHashMap();
    private static final Node<JsonObject> VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final JsonObject delivery = new JsonObject();

    private static void initOptions(JsonObject options) {
        if (!Ut.isNil((JsonObject)options)) {
            options.fieldNames().forEach(className -> {
                Class clazz = Ut.clazz((String)className);
                JsonObject option = options.getJsonObject(className);
                OPTIONS.put(clazz, option);
            });
        }
    }

    @Override
    public DeploymentOptions spinAgent(Class<?> clazz) {
        Agent annotation = clazz.getDeclaredAnnotation(Agent.class);
        DeploymentOptions options = this.spinOpt(clazz, (Annotation)annotation);
        options.setWorker(false);
        LOGGER.info("( Verticle ) The deployment options has been captured: instances = {0}, group = {1}, ha = {2}, content = {3}", new Object[]{options.getInstances(), options.getIsolationGroup(), options.isHa(), options.toJson()});
        return options;
    }

    @Override
    public DeliveryOptions spinDelivery() {
        DeliveryOptions options = new DeliveryOptions();
        options.setSendTimeout(delivery.getLong("timeout", Long.valueOf(options.getSendTimeout())).longValue());
        return options;
    }

    @Override
    public DeploymentOptions spinWorker(Class<?> clazz) {
        Worker annotation = clazz.getDeclaredAnnotation(Worker.class);
        DeploymentOptions options = this.spinOpt(clazz, (Annotation)annotation);
        options.setWorker(true);
        LOGGER.info("( Verticle ) The deployment options has been captured: instances = {0}, group = {1}, ha = {2}, content = {3}", new Object[]{options.getInstances(), options.getIsolationGroup(), options.isHa(), options.toJson()});
        return options;
    }

    private DeploymentOptions spinOpt(Class<?> clazz, Annotation annotation) {
        DeploymentOptions options;
        if (!OPTIONS.isEmpty()) {
            JsonObject configOpts = OPTIONS.getOrDefault(clazz, new JsonObject());
            options = new DeploymentOptions(configOpts);
            if (configOpts.containsKey("workerPoolSize")) {
                options.setWorkerPoolSize(configOpts.getInteger("workerPoolSize").intValue());
            }
        } else {
            options = new DeploymentOptions();
        }
        int instances = (Integer)Ut.invoke((Object)annotation, (String)"instances", (Object[])new Object[0]);
        boolean ha = (Boolean)Ut.invoke((Object)annotation, (String)"ha", (Object[])new Object[0]);
        String group = (String)Ut.invoke((Object)annotation, (String)"group", (Object[])new Object[0]);
        options.setHa(ha);
        options.setInstances(instances);
        return options;
    }

    static {
        JsonObject options = (JsonObject)VISITOR.read();
        if (options.containsKey("deployment")) {
            JsonObject deployOptions = options.getJsonObject("deployment");
            Arrange arrange = (Arrange)Ut.deserialize((JsonObject)deployOptions, Arrange.class);
            DeployMode mode = arrange.getMode();
            if (DeployMode.CONFIG == mode) {
                LOGGER.info("Zero container will select new DeployMode ( mode = {0} ).", new Object[]{mode});
                DeployRotate.initOptions(arrange.getOptions());
            }
            if (Objects.nonNull(arrange.getDelivery())) {
                delivery.mergeIn(arrange.getDelivery());
            }
        }
    }
}

