/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.runtime.soul;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.vertx.core.http.HttpMethod;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;

public class UriMeta
implements Serializable {
    private transient String uri;
    private transient HttpMethod method;
    private transient String key;
    private transient String comment;
    private transient String name;
    private transient boolean dynamic;
    private transient String address;
    @JsonIgnore
    private transient Class<?> workerClass;
    @JsonIgnore
    private transient Method workerMethod;

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @JsonIgnore
    public String getCacheKey() {
        if (Objects.isNull(this.method) || Objects.isNull(this.uri)) {
            return null;
        }
        return this.method.name() + ":" + this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Class<?> getWorkerClass() {
        return this.workerClass;
    }

    public void setWorkerClass(Class<?> workerClass) {
        this.workerClass = workerClass;
    }

    public Method getWorkerMethod() {
        return this.workerMethod;
    }

    public void setWorkerMethod(Method workerMethod) {
        this.workerMethod = workerMethod;
        this.workerClass = workerMethod.getDeclaringClass();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriMeta uriMeta = (UriMeta)o;
        return this.uri.equals(uriMeta.uri) && this.method == uriMeta.method;
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.method);
    }
}

