/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.cosmic;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.config.IntegrationRequest;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.cosmic.AbstractEmitter;
import io.vertx.up.uca.cosmic.Pool;
import io.vertx.up.uca.cosmic.Rotator;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class StandardEmitter
extends AbstractEmitter {
    private transient CloseableHttpClient client;

    StandardEmitter(Integration integration) {
        super(integration);
        this.initialize();
    }

    @Override
    protected void initialize() {
        SSLContext sslcontext = this.sslContext();
        RegistryBuilder registry = RegistryBuilder.create();
        registry.register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
        if (Objects.nonNull(sslcontext)) {
            registry.register("https", (Object)new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        }
        Registry factory = registry.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(factory);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    @Override
    public String request(String apiKey, JsonObject params, MultiMap headers) {
        Function executor;
        IntegrationRequest request = this.integration().createRequest(apiKey);
        if (Objects.nonNull(headers)) {
            request.setHeaders(Ut.toJObject((MultiMap)headers));
        }
        if (Objects.isNull(executor = (Function)Pool.POOL_ROTATOR_FN.get(request.getMethod()))) {
            return "";
        }
        Rotator rotator = (Rotator)Fn.pool(Pool.POOL_ROTATOR, (Object)request.hashCode(), () -> ((Rotator)executor.apply(this.integration())).bind(this.client));
        return rotator.request(request, params);
    }
}

