/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.di;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;

public class JsrDi<I, T extends I>
extends AbstractModule {
    private static final Annal LOGGER = Annal.get(JsrDi.class);
    private final transient ConcurrentMap<Class<I>, Set<Class<T>>> classes = new ConcurrentHashMap<Class<I>, Set<Class<T>>>();

    public JsrDi(ConcurrentMap<Class<I>, Set<Class<T>>> classes) {
        this.classes.putAll(classes);
    }

    protected void configure() {
        LOGGER.info("[ DI ] Jsr Bind Start......", new Object[0]);
        HashSet ignored = new HashSet();
        this.classes.forEach((interfaceCls, implSet) -> {
            if (1 == implSet.size()) {
                Class impl = (Class)implSet.iterator().next();
                LOGGER.info("[ DI ] 1 --> 1, Interface clazz bind = {0}, interface = {1}", new Object[]{impl, interfaceCls});
                this.bind((Class)interfaceCls).to(impl).asEagerSingleton();
            } else {
                implSet.forEach(implCls -> {
                    if (implCls.isAnnotationPresent(Named.class)) {
                        LOGGER.info("[ DI ] 1 --> 1, Interface named bind = {0}, interface = {1}", new Object[]{implCls, interfaceCls});
                        Named annotation = implCls.getAnnotation(Named.class);
                        String name = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
                        this.bind((Class)interfaceCls).annotatedWith((Annotation)Names.named((String)name)).to(implCls).asEagerSingleton();
                    } else {
                        ignored.add(implCls.getName());
                    }
                });
            }
        });
        LOGGER.info("[ DI ] ?, Size = {0}, No definition!!!! Impl = {1}", new Object[]{String.valueOf(ignored.size()), Ut.fromJoin(ignored)});
    }
}

