/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.center;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.up.annotations.Contract;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Envelop;
import io.vertx.up.eon.em.JobStatus;
import io.vertx.up.fn.Actuator;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.center.Agha;
import io.vertx.up.uca.job.phase.Phase;
import io.vertx.up.uca.job.store.JobConfig;
import io.vertx.up.uca.job.store.JobPin;
import io.vertx.up.uca.job.store.JobStore;
import io.vertx.up.uca.job.timer.Interval;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAgha
implements Agha {
    private static final JobConfig CONFIG = JobPin.getConfig();
    private static final AtomicBoolean SELECTED = new AtomicBoolean(Boolean.TRUE);
    private static final ConcurrentMap<JobStatus, JobStatus> MOVING = new ConcurrentHashMap<JobStatus, JobStatus>(){
        {
            this.put(JobStatus.STARTING, JobStatus.READY);
            this.put(JobStatus.READY, JobStatus.RUNNING);
            this.put(JobStatus.RUNNING, JobStatus.STOPPED);
            this.put(JobStatus.STOPPED, JobStatus.READY);
            this.put(JobStatus.ERROR, JobStatus.READY);
        }
    };
    @Contract
    private transient Vertx vertx;

    Interval interval() {
        Class intervalCls = CONFIG.getInterval().getComponent();
        Interval interval = (Interval)Ut.singleton((Class)intervalCls, (Object[])new Object[0]);
        Ut.contract((Object)interval, Vertx.class, (Object)this.vertx);
        if (SELECTED.getAndSet(Boolean.FALSE)) {
            this.getLogger().info("[ Job ] {0} selected: {1}", new Object[]{"Interval", interval.getClass().getName()});
        }
        return interval;
    }

    JobStore store() {
        return JobPin.getStore();
    }

    private Future<Envelop> workingAsync(Mission mission) {
        Phase phase = Phase.start(mission.getCode()).bind(this.vertx).bind(mission);
        return phase.inputAsync(mission).compose(phase::incomeAsync).compose(phase::invokeAsync).compose(phase::outcomeAsync).compose(phase::outputAsync).compose(phase::callbackAsync);
    }

    void working(Mission mission, Actuator actuator) {
        if (JobStatus.READY == mission.getStatus()) {
            this.moveOn(mission, true);
            long threshold = mission.getThreshold();
            if (-1L == threshold) {
                threshold = TimeUnit.MINUTES.toNanos(5L);
            }
            String code = mission.getCode();
            WorkerExecutor executor = this.vertx.createSharedWorkerExecutor(code, 1, threshold);
            this.getLogger().info("[ Job ] `{0}` worker executor will be created. The max executing time is {1} s", new Object[]{code, String.valueOf(TimeUnit.NANOSECONDS.toSeconds(threshold))});
            executor.executeBlocking(promise -> promise.handle((AsyncResult)this.workingAsync(mission).compose(result -> {
                actuator.execute();
                this.getLogger().info("[ Job ] `{0}` worker executor has been closed! ", new Object[]{code});
                return Future.succeededFuture((Object)result);
            }).otherwise(error -> {
                if (!(error instanceof NoStackTraceThrowable)) {
                    error.printStackTrace();
                    this.moveOn(mission, false);
                }
                return Envelop.failure(error);
            })), handler -> {
                Throwable error;
                if (handler.succeeded()) {
                    executor.close();
                } else if (Objects.nonNull(handler.cause()) && !((error = handler.cause()) instanceof NoStackTraceThrowable)) {
                    error.printStackTrace();
                }
            });
        }
    }

    void moveOn(Mission mission, boolean noError) {
        if (noError) {
            if (MOVING.containsKey(mission.getStatus())) {
                JobStatus moved = (JobStatus)MOVING.get(mission.getStatus());
                JobStatus original = mission.getStatus();
                mission.setStatus(moved);
                this.getLogger().info("[ Job ] Job `{1}`\uff08 Moved: {2} -> {3} \uff09, Type = {0}", new Object[]{mission.getType(), mission.getCode(), original, moved});
                this.store().update(mission);
            }
        } else if (JobStatus.RUNNING == mission.getStatus()) {
            mission.setStatus(JobStatus.ERROR);
            this.getLogger().info("[ Job ] {0} The job will be terminal, status -> ERROR", new Object[]{mission.getCode()});
            this.store().update(mission);
        }
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

