/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.job.phase;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.web._417JobMethodException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.job.phase.Element;
import io.vertx.up.uca.serialization.TypedArgument;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;

class RunOn {
    private static final Annal LOGGER = Annal.get(RunOn.class);
    private final transient Vertx vertx;
    private final transient Refer underway = new Refer();

    RunOn(Vertx vertx) {
        this.vertx = vertx;
    }

    RunOn bind(Refer underway) {
        if (Objects.nonNull(underway)) {
            this.underway.add(underway.get());
        }
        return this;
    }

    Future<Envelop> invoke(Envelop envelop, Mission mission) {
        Method method = mission.getOn();
        if (Objects.nonNull(method)) {
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 3. --> @On Method call {1}", new Object[]{mission.getCode(), method.getName()}));
            return this.execute(envelop, method, mission);
        }
        return Ux.future(envelop);
    }

    Future<Envelop> callback(Envelop envelop, Mission mission) {
        Method method = mission.getOff();
        if (Objects.nonNull(method)) {
            Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] 6. --> @Off Method call {1}", new Object[]{mission.getCode(), method.getName()}));
            return this.execute(envelop, method, mission);
        }
        return Ux.future(envelop);
    }

    private Future<Envelop> execute(Envelop envelop, Method method, Mission mission) {
        if (envelop.valid()) {
            Object proxy = mission.getProxy();
            try {
                Object[] arguments = this.buildArgs(envelop, method, mission);
                return Ut.invokeAsync((Object)proxy, (Method)method, (Object[])arguments).compose(this::normalize);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return Future.failedFuture((Throwable)ex);
            }
        }
        Element.onceLog(mission, () -> LOGGER.info("[ Job: {0} ] Terminal with error: {1}", new Object[]{mission.getCode(), ((Object)((Object)envelop.error())).getClass().getName()}));
        return Ux.future(envelop);
    }

    private <T> Future<Envelop> normalize(T returnValue) {
        if (Objects.isNull(returnValue)) {
            return Ux.future(Envelop.okJson());
        }
        if (Envelop.class == returnValue.getClass()) {
            return Future.succeededFuture((Object)((Envelop)returnValue));
        }
        return Ux.future(Envelop.success(returnValue));
    }

    private Object[] buildArgs(Envelop envelop, Method method, Mission mission) {
        Class<?>[] parameters = method.getParameterTypes();
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (0 < parameters.length) {
            for (Class<?> parameterType : parameters) {
                argsList.add(TypedArgument.analyzeJob(envelop, parameterType, mission, this.underway));
            }
        } else {
            throw new _417JobMethodException(this.getClass(), mission.getCode());
        }
        return argsList.toArray();
    }
}

