/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.github.jklingsporn.vertx.jooq.classic.VertxDAO;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqDsl;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.util.Ut;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Operator;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.True;
import org.jooq.UniqueKey;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;

abstract class AbstractAction {
    protected final transient JooqDsl dsl;
    protected final transient JqAnalyzer analyzer;

    protected AbstractAction(JqAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.dsl = analyzer.dsl();
    }

    protected VertxDAO dao() {
        return this.dsl.dao();
    }

    protected DSLContext context() {
        return this.dsl.context();
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected Collection<Object> parameters(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Arrays.asList(value);
    }

    protected Condition condition(JsonObject criteria) {
        return Ut.isNil((JsonObject)criteria) ? null : JooqCond.transform((JsonObject)criteria, this.analyzer::column);
    }

    protected Condition conditionAnd(JsonObject criteria) {
        return JooqCond.transform((JsonObject)criteria, (Operator)Operator.AND, this.analyzer::column);
    }

    protected <T> Record newRecord(T pojo) {
        Objects.requireNonNull(pojo);
        Record record = this.context().newRecord(this.analyzer.table(), pojo);
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            Field field;
            if (record.get(i) != null || (field = record.field(i)).getDataType().nullable() || field.getDataType().identity()) continue;
            record.set(field, (Object)DSL.defaultValue());
        }
        return record;
    }

    protected <T> UpdateConditionStep editRecord(T pojo) {
        Objects.requireNonNull(pojo);
        Record record = this.context().newRecord(this.analyzer.table(), pojo);
        True where = DSL.trueCondition();
        UniqueKey pk = this.analyzer.table().getPrimaryKey();
        for (TableField tableField : pk.getFields()) {
            record.changed((Field)tableField, false);
            where = where.and(tableField.eq(record.get((Field)tableField)));
        }
        Map valuesToUpdate = Arrays.stream(record.fields()).collect(HashMap::new, (m, f) -> m.put(f.getName(), f.getValue(record)), HashMap::putAll);
        return this.context().update(this.analyzer.table()).set(valuesToUpdate).where((Condition)where);
    }
}

