/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jooq.InsertSetMoreStep;
import org.jooq.InsertSetStep;
import org.jooq.InsertValuesStepN;

class ActionInsert
extends AbstractAction {
    ActionInsert(JqAnalyzer analyzer) {
        super(analyzer);
    }

    <T> Future<T> insertAsync(T entity) {
        Objects.requireNonNull(entity);
        T inserted = this.uuid(entity);
        return ((Future)this.dao().insert(inserted)).compose(rows -> {
            this.logger().info("[ Jq ] insertAsync(T) executed rows: {0}", new Object[]{String.valueOf(rows)});
            return Future.succeededFuture((Object)entity);
        });
    }

    <T> T insert(T entity) {
        Objects.requireNonNull(entity);
        T inserted = this.uuid(entity);
        InsertSetMoreStep insertStep = this.context().insertInto(this.analyzer.table()).set(this.newRecord(inserted));
        int rows = insertStep.execute();
        this.logger().info("[ Jq ] insert(T) executed rows: {0}", new Object[]{String.valueOf(rows)});
        return inserted;
    }

    <T> Future<List<T>> insertAsync(List<T> list) {
        Objects.requireNonNull(list);
        List<T> inserted = this.uuid((T)list);
        return ((Future)this.dao().insert(inserted, true)).compose(rows -> {
            this.logger().info("[ Jq ] insertAsync(List<T>) executed rows: {0}/{1}", new Object[]{String.valueOf(rows), String.valueOf(list.size())});
            return Future.succeededFuture((Object)list);
        });
    }

    <T> List<T> insert(List<T> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return list;
        }
        List<T> inserted = this.uuid((T)list);
        InsertSetStep insertStep = this.context().insertInto(this.analyzer.table());
        InsertValuesStepN insertValuesStepN = null;
        for (T pojo : inserted) {
            insertValuesStepN = insertStep.values(this.newRecord(pojo).intoArray());
        }
        int rows = insertValuesStepN.onDuplicateKeyIgnore().execute();
        this.logger().info("[ Jq ] insert(List<T>) executed rows: {0}/{1}", new Object[]{String.valueOf(rows), String.valueOf(list.size())});
        return list;
    }

    private <T> List<T> uuid(List<T> list) {
        list.forEach(this::uuid);
        return list;
    }

    private <T> T uuid(T input) {
        if (Objects.nonNull(input)) {
            try {
                String primaryKey = this.analyzer.primary();
                String primaryField = Objects.isNull(primaryKey) ? null : primaryKey;
                Object keyValue = Ut.field(input, (String)primaryField);
                if (Objects.isNull(keyValue)) {
                    Ut.field(input, (String)primaryField, (Object)UUID.randomUUID().toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return input;
    }
}

