/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.condition.JooqCond;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.util.JqOut;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.SelectConditionStep;
import org.jooq.SelectLimitPercentAfterOffsetStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWhereStep;

public class ActionQr
extends AbstractAction {
    public ActionQr(JqAnalyzer analyzer) {
        super(analyzer);
    }

    <T> Future<List<T>> searchAsync(Qr qr) {
        Function<DSLContext, List> executor = context -> this.searchInternal((DSLContext)context, qr);
        return Future.succeededFuture((Object)executor.apply(this.context()));
    }

    <T> Future<List<T>> searchAsync(JsonObject criteria) {
        Function<DSLContext, List> executor = context -> this.searchInternal((DSLContext)context, criteria);
        return Future.succeededFuture((Object)executor.apply(this.context()));
    }

    <T> List<T> search(Qr qr) {
        return this.searchInternal(this.context(), qr);
    }

    <T> List<T> search(JsonObject criteria) {
        return this.searchInternal(this.context(), criteria);
    }

    public <T> List<Object> searchPrimary(JsonObject criteria) {
        List<T> entities = this.search(criteria);
        return this.analyzer.primaryValue(entities);
    }

    private <T> List<T> searchInternal(DSLContext context, JsonObject criteria) {
        SelectWhereStep started = context.selectFrom(this.analyzer.table());
        SelectConditionStep conditionStep = null;
        if (null != criteria) {
            Condition condition = JooqCond.transform((JsonObject)criteria, this.analyzer::column);
            conditionStep = started.where(condition);
        }
        return started.fetchInto(this.analyzer.type());
    }

    private <T> List<T> searchInternal(DSLContext context, Qr qr) {
        Set projectionSet;
        JsonArray projection;
        SelectWhereStep started = context.selectFrom(this.analyzer.table());
        SelectConditionStep conditionStep = null;
        if (null != qr.getCriteria()) {
            JsonObject criteria = qr.getCriteria().toJson();
            Condition condition = JooqCond.transform((JsonObject)criteria, this.analyzer::column);
            conditionStep = started.where(condition);
        }
        SelectSeekStepN selectStep = null;
        if (null != qr.getSorter()) {
            List orders = JooqCond.orderBy((Sorter)qr.getSorter(), this.analyzer::column, null);
            selectStep = null == conditionStep ? started.orderBy((Collection)orders) : conditionStep.orderBy((Collection)orders);
        }
        SelectLimitPercentAfterOffsetStep pagerStep = null;
        if (null != qr.getPager()) {
            Pager pager = qr.getPager();
            pagerStep = null == selectStep && null == conditionStep ? started.offset(pager.getStart()).limit(pager.getSize()) : (null == selectStep ? conditionStep.offset(pager.getStart()).limit(pager.getSize()) : selectStep.offset(pager.getStart()).limit(pager.getSize()));
        }
        JsonArray jsonArray = projection = Objects.isNull(projectionSet = qr.getProjection()) ? new JsonArray() : Ut.toJArray((Set)projectionSet);
        if (null != pagerStep) {
            return JqOut.toResult(pagerStep.fetchInto(this.analyzer.type()), projection, this.analyzer);
        }
        if (null != selectStep) {
            return JqOut.toResult(selectStep.fetchInto(this.analyzer.type()), projection, this.analyzer);
        }
        if (null != conditionStep) {
            return JqOut.toResult(conditionStep.fetchInto(this.analyzer.type()), projection, this.analyzer);
        }
        return JqOut.toResult(started.fetchInto(this.analyzer.type()), projection, this.analyzer);
    }
}

