/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.jooq.AbstractAction;
import io.vertx.up.uca.jooq.ActionFetch;
import io.vertx.up.uca.jooq.JqAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jooq.UpdateConditionStep;

class ActionUpdate
extends AbstractAction {
    private transient ActionFetch fetch;

    ActionUpdate(JqAnalyzer analyzer) {
        super(analyzer);
        this.fetch = new ActionFetch(analyzer);
    }

    <T> Future<T> updateAsync(T entity) {
        Objects.requireNonNull(entity);
        return ((Future)this.dao().update(entity)).compose(rows -> {
            this.logger().info("[ Jq ] updateAsync(T) executed rows: {0}", new Object[]{String.valueOf(rows)});
            return Future.succeededFuture((Object)entity);
        });
    }

    <T> T update(T entity) {
        Objects.requireNonNull(entity);
        UpdateConditionStep updateStep = this.editRecord(entity);
        int rows = updateStep.execute();
        this.logger().info("[ Jq ] update(T) executed rows: {0}", new Object[]{String.valueOf(rows)});
        return entity;
    }

    <T> Future<List<T>> updateAsync(List<T> list) {
        return this.dsl.executeBlocking(h -> h.complete(this.update(list)));
    }

    <T> List<T> update(List<T> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return list;
        }
        ArrayList batchOps = new ArrayList();
        list.stream().map(this::editRecord).forEach(batchOps::add);
        int[] rows = this.context().batch(batchOps).execute();
        long updated = Arrays.stream(rows).filter(value -> 1 == value).count();
        this.logger().info("[ Jq ] update(List<T>) executed rows: {0}/{1}", new Object[]{String.valueOf(updated), String.valueOf(rows.length)});
        return list;
    }

    <T, ID> Future<T> updateAsync(ID id, T updated) {
        return this.fetch.fetchByIdAsync(id).compose(previous -> {
            Object combine = this.analyzer.copyEntity(previous, updated);
            return this.updateAsync(combine);
        });
    }

    <T, ID> T update(ID id, T updated) {
        Object previous = this.fetch.fetchById(id);
        Object combine = this.analyzer.copyEntity(previous, updated);
        return this.update(combine);
    }

    <T> Future<T> updateAsync(JsonObject criteria, T updated) {
        return this.fetch.fetchOneAsync(criteria).compose(previous -> {
            Object combine = this.analyzer.copyEntity(previous, updated);
            return this.updateAsync(combine);
        });
    }

    <T> T update(JsonObject criteria, T updated) {
        Object previous = this.fetch.fetchOne(criteria);
        Object combine = this.analyzer.copyEntity(previous, updated);
        return this.update(combine);
    }
}

