/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.jooq.util;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.pojo.Mirror;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.atom.query.engine.Qr;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.util.JqFlow;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JqTool {
    private static final Annal LOGGER = Annal.get(JqTool.class);

    public static <T> CompositeFuture joinAsync(JsonObject criteria, JsonObject data, JqFlow flow) {
        Future<JsonObject> criteriaFuture = flow.inputQrJAsync(criteria);
        Future dataFuture = flow.inputAsync(data);
        return CompositeFuture.join(criteriaFuture, dataFuture);
    }

    public static <T> CompositeFuture joinAsync(JsonObject criteria, JsonArray data, JqFlow flow) {
        Future<JsonObject> criteriaFuture = flow.inputQrJAsync(criteria);
        Future dataFuture = flow.inputAsync(data);
        return CompositeFuture.join(criteriaFuture, dataFuture);
    }

    public static Qr qr(JsonObject envelop, String pojo) {
        return (Qr)Fn.getNull((Object)Qr.create((JsonObject)new JsonObject()), () -> {
            JsonObject data = envelop.copy();
            if (Ut.isNil((String)pojo)) {
                return Qr.create((JsonObject)data);
            }
            Mojo mojo = Mirror.create(JqTool.class).mount(pojo).mojo();
            return JqTool.qr(data, mojo);
        }, (Object[])new Object[]{envelop});
    }

    public static Qr qr(JsonObject data, Mojo mojo) {
        return JqTool.qr(data, mojo, new HashSet<String>());
    }

    public static Qr qr(JsonObject data, Mojo mojo, Set<String> ignoreSet) {
        if (data.containsKey("projection")) {
            data.put("projection", (Object)JqTool.projection(data.getJsonArray("projection"), mojo, ignoreSet));
        }
        if (data.containsKey("sorter")) {
            data.put("sorter", (Object)JqTool.sorter(data.getJsonArray("sorter"), mojo, ignoreSet));
        }
        if (data.containsKey("criteria")) {
            data.put("criteria", (Object)JqTool.criteria(data.getJsonObject("criteria"), mojo, ignoreSet));
        }
        LOGGER.info("( Qr ) Processed metadata = {0}.", new Object[]{data.encode()});
        return Qr.create((JsonObject)data);
    }

    public static JsonObject criteria(JsonObject criteria, String pojo) {
        Qr qr = JqTool.qr(new JsonObject().put("criteria", (Object)criteria), pojo);
        return Objects.isNull(qr.getCriteria()) ? new JsonObject() : qr.getCriteria().toJson();
    }

    public static JsonObject criteria(JsonObject criteria, Mojo mojo) {
        return JqTool.criteria(criteria, mojo, new HashSet<String>());
    }

    public static JsonObject criteria(JsonObject criteria, Mojo mojo, Set<String> ignoreSet) {
        JsonObject condition = new JsonObject();
        ConcurrentMap<String, String> mapping = JqTool.joinMapping(mojo, ignoreSet);
        for (String field : criteria.fieldNames()) {
            String key;
            String string = key = field.contains(",") ? field.split(",")[0] : field;
            if (mapping.containsKey(key)) {
                Object targetField = field.contains(",") ? (String)mapping.get(key) + "," + field.split(",")[1] : (String)mapping.get(key);
                condition.put((String)targetField, criteria.getValue(field));
                continue;
            }
            if (Ut.isJObject((Object)criteria.getValue(field)) || field.equals("")) {
                if (Ut.isJObject((Object)criteria.getValue(field))) {
                    JsonObject valueJson = criteria.getJsonObject(field);
                    condition.put(field, (Object)JqTool.criteria(valueJson, mojo, ignoreSet));
                    continue;
                }
                condition.put(field, criteria.getValue(field));
                continue;
            }
            condition.put(field, criteria.getValue(field));
        }
        return condition;
    }

    private static JsonArray projection(JsonArray projections, Mojo mojo, Set<String> ignoreSet) {
        JsonArray result = new JsonArray();
        ConcurrentMap<String, String> mapping = JqTool.joinMapping(mojo, ignoreSet);
        Ut.itJArray((JsonArray)projections, String.class, (item, index) -> result.add((Object)(null == mapping.get(item) ? item : mapping.get(item))));
        return result;
    }

    private static JsonArray sorter(JsonArray sorter, Mojo mojo, Set<String> ignoreSet) {
        JsonArray sorters = new JsonArray();
        ConcurrentMap<String, String> mapping = JqTool.joinMapping(mojo, ignoreSet);
        Ut.itJArray((JsonArray)sorter, String.class, (item, index) -> {
            String key;
            String string = key = item.contains(",") ? item.split(",")[0] : item;
            if (mapping.containsKey(key)) {
                String targetField = (String)mapping.get(key);
                if (item.contains(",")) {
                    sorters.add((Object)(targetField + "," + item.split(",")[1]));
                } else {
                    sorters.add((Object)(targetField + ",ASC"));
                }
            } else {
                sorters.add(item);
            }
        });
        return sorters;
    }

    private static ConcurrentMap<String, String> joinMapping(Mojo mojo, Set<String> ignoreSet) {
        ConcurrentMap mapping = mojo.getIn();
        if (Objects.isNull(ignoreSet) || ignoreSet.isEmpty()) {
            return mapping;
        }
        ConcurrentHashMap<String, String> filteredMap = new ConcurrentHashMap<String, String>();
        mapping.forEach((key, value) -> {
            if (!ignoreSet.contains(key)) {
                filteredMap.put((String)key, (String)value);
            }
        });
        return filteredMap;
    }
}

