/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.monitor.meansure;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.healthchecks.Status;
import io.vertx.up.uca.monitor.meansure.AbstractQuota;
import io.vertx.up.unity.Ux;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class VerticleQuota
extends AbstractQuota {
    VerticleQuota(Vertx vertx) {
        super(vertx);
    }

    public void handle(Promise<Status> event) {
        this.mapAsync("zero.pool.deployment", map -> {
            ConcurrentHashMap mapped = new ConcurrentHashMap();
            map.keys(keyRes -> {
                if (keyRes.succeeded()) {
                    Set keys = (Set)keyRes.result();
                    keys.forEach(key -> mapped.put(key, this.readAsync((String)key, (AsyncMap<String, Object>)map)));
                }
            });
            Future future = Ux.thenCombine(mapped);
            future.onComplete(handler -> {
                if (handler.succeeded()) {
                    JsonObject meansure = new JsonObject();
                    ConcurrentMap result = (ConcurrentMap)handler.result();
                    result.forEach((arg_0, arg_1) -> ((JsonObject)meansure).put(arg_0, arg_1));
                    event.complete((Object)Status.OK((JsonObject)meansure));
                }
            });
        });
    }

    private Future<JsonObject> readAsync(String name, AsyncMap<String, Object> map) {
        Promise promise = Promise.promise();
        map.get((Object)name, res -> {
            if (res.succeeded()) {
                JsonObject completed = (JsonObject)res.result();
                promise.complete((Object)completed);
            }
        });
        return promise.future();
    }
}

