/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.hunt;

import io.vertx.core.Future;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.up.annotations.SessionData;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.extension.pointer.PluginExtension;
import io.vertx.up.uca.rs.hunt.Outcome;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;

public final class Answer {
    public static Envelop previous(RoutingContext context) {
        Envelop envelop = (Envelop)context.get("$$CONTEXT_REQUEST$$");
        if (Objects.isNull(envelop)) {
            envelop = Envelop.failure(new _500InternalServerException(Answer.class, "Previous Error of $$CONTEXT_REQUEST$$"));
        }
        return envelop;
    }

    public static void next(RoutingContext context, Envelop envelop) {
        if (envelop.valid()) {
            context.put("$$CONTEXT_REQUEST$$", (Object)envelop);
            context.next();
        } else {
            Answer.reply(context, envelop);
        }
    }

    public static void normalize(RoutingContext context, Envelop envelop) {
        if (envelop.valid()) {
            envelop.bind(context);
            context.put("$$CONTEXT_REQUEST$$", (Object)envelop);
            context.next();
        } else {
            Answer.reply(context, envelop);
        }
    }

    public static void reply(RoutingContext context, Envelop envelop) {
        Answer.reply(context, envelop, new HashSet<MediaType>());
    }

    public static void reply(RoutingContext context, Envelop envelop, Supplier<Set<MediaType>> supplier) {
        HashSet<MediaType> produces;
        Set<Object> set = produces = Objects.isNull(supplier) ? new HashSet() : supplier.get();
        if (Objects.isNull(produces)) {
            produces = new HashSet();
        }
        Answer.reply(context, envelop, produces);
    }

    public static void reply(RoutingContext context, Envelop envelop, Event event) {
        Set<MediaType> produces;
        if (Objects.isNull(event)) {
            produces = new HashSet<MediaType>();
        } else {
            produces = event.getProduces();
            if (Objects.isNull(produces)) {
                produces = new HashSet<MediaType>();
            }
        }
        Answer.reply(context, envelop, produces, Objects.isNull(event) ? null : event.getAction());
    }

    private static void reply(RoutingContext context, Envelop envelop, Set<MediaType> mediaTypes) {
        Answer.reply(context, envelop, mediaTypes, null);
    }

    private static void reply(RoutingContext context, Envelop envelop, Set<MediaType> mediaTypes, Method sessionAction) {
        HttpServerResponse response = context.response();
        if (!response.closed()) {
            HttpStatusCode code = envelop.status();
            response.setStatusCode(code.code());
            response.setStatusMessage(code.message());
            envelop.bind(context);
            Outcome.media(response, mediaTypes);
            if (envelop.valid()) {
                Outcome.security(response);
                Answer.storeSession(context, envelop.data(), sessionAction);
            }
            PluginExtension.Answer.reply(context, envelop).compose(processed -> {
                Outcome.out(response, processed, mediaTypes);
                return Future.succeededFuture();
            });
        }
    }

    private static <T> void storeSession(RoutingContext context, T data, Method method) {
        Session session = context.session();
        if (null != session && null != data && Objects.nonNull(method) && method.isAnnotationPresent(SessionData.class)) {
            SessionData annotation = method.getAnnotation(SessionData.class);
            String key = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            String field = (String)Ut.invoke((Object)annotation, (String)"field", (Object[])new Object[0]);
            Object reference = data;
            if (Ut.isJObject(data) && Ut.notNil((String)field)) {
                JsonObject target = (JsonObject)data;
                reference = target.getValue(field);
            }
            session.put(key, reference);
        }
    }
}

