/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.hunt;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.container.VInstance;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.rs.Aim;
import io.vertx.up.uca.rs.hunt.Answer;
import io.vertx.up.uca.rs.hunt.BaseAim;
import io.vertx.up.uca.rs.hunt.Flower;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public class AsyncAim
extends BaseAim
implements Aim<RoutingContext> {
    @Override
    public Handler<RoutingContext> attack(Event event) {
        return (Handler)Fn.getNull(() -> context -> this.exec(() -> {
            Future<Envelop> future = this.invoke((RoutingContext)context, event);
            Vertx vertx = context.vertx();
            EventBus bus = vertx.eventBus();
            String address = this.address(event);
            future.onComplete(dataRes -> {
                if (dataRes.succeeded()) {
                    Envelop request = (Envelop)dataRes.result();
                    bus.request(address, (Object)request, Ux.Opt.on().delivery(), handler -> {
                        Envelop response = handler.succeeded() ? this.success(address, (AsyncResult<Message<Envelop>>)handler) : this.failure(address, (AsyncResult<Message<Envelop>>)handler);
                        response.from(request);
                        Answer.reply(context, response, event);
                    });
                } else {
                    if (Objects.nonNull(dataRes.cause())) {
                        dataRes.cause().printStackTrace();
                    }
                    Answer.reply(context, Envelop.failure(dataRes.cause()));
                }
            });
        }, (RoutingContext)context, event), (Object[])new Object[]{event});
    }

    private Future<Envelop> invoke(RoutingContext context, Event event) {
        Future<Envelop> invoked;
        Object proxy = event.getProxy();
        Object[] arguments = this.buildArgs(context, event);
        if (proxy instanceof VInstance) {
            JsonObject message = new JsonObject();
            for (int idx = 0; idx < arguments.length; ++idx) {
                message.put(String.valueOf(idx), arguments[idx]);
            }
            invoked = Flower.next(context, message);
        } else {
            Object returnValue = this.invoke(event, arguments);
            invoked = Flower.next(context, returnValue);
        }
        return invoked.compose(response -> {
            response.bind(context);
            return Ux.future(response);
        });
    }
}

