/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.rs.router;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.secure.bridge.Bolt;
import io.vertx.up.uca.rs.Axis;
import io.vertx.up.uca.rs.router.Pool;
import io.vertx.up.uca.web.failure.AuthenticateEndurer;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class WallAxis
implements Axis<Router> {
    private static final Set<Aegis> WALLS = ZeroAnno.getWalls();
    private final transient Vertx vertx;
    private final transient Bolt bolt;

    public WallAxis(Vertx vertx) {
        this.vertx = vertx;
        this.bolt = Bolt.get();
    }

    @Override
    public void mount(Router router) {
        Pool.WALL_MAP.forEach((path, aegisSet) -> {
            if (!aegisSet.isEmpty()) {
                this.mountAuthenticate(router, (String)path, (Set<Aegis>)aegisSet);
                this.mountAuthorization(router, (String)path, (Set<Aegis>)aegisSet);
            }
        });
    }

    private void mountAuthenticate(Router router, String path, Set<Aegis> aegisSet) {
        AuthenticationHandler resultHandler;
        if (1 == aegisSet.size()) {
            Aegis aegis = aegisSet.iterator().next();
            resultHandler = this.bolt.authenticate(this.vertx, aegis);
        } else {
            ChainAuthHandler handler = ChainAuthHandler.all();
            aegisSet.stream().map(item -> this.bolt.authenticate(this.vertx, (Aegis)item)).filter(Objects::nonNull).forEach(arg_0 -> ((ChainAuthHandler)handler).add(arg_0));
            resultHandler = handler;
        }
        if (Objects.nonNull(resultHandler)) {
            router.route(path).order(1900000).handler((Handler)resultHandler).failureHandler(AuthenticateEndurer.create());
        }
    }

    private void mountAuthorization(Router router, String path, Set<Aegis> aegisSet) {
        AuthorizationHandler resultHandler;
        if (1 == aegisSet.size()) {
            Aegis aegis = aegisSet.iterator().next();
            resultHandler = this.bolt.authorization(this.vertx, aegis);
        } else {
            Aegis aegis = new TreeSet<Aegis>(Comparator.comparingInt(Aegis::getOrder)).iterator().next();
            resultHandler = this.bolt.authorization(this.vertx, aegis);
        }
        if (Objects.nonNull(resultHandler)) {
            router.route(path).order(2000000).handler((Handler)resultHandler).failureHandler(AuthenticateEndurer.create());
        }
    }

    static {
        WALLS.forEach(wall -> {
            if (!Pool.WALL_MAP.containsKey(wall.getPath())) {
                Pool.WALL_MAP.put(wall.getPath(), new TreeSet());
            }
            ((Set)Pool.WALL_MAP.get(wall.getPath())).add(wall);
        });
    }
}

