/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.serialization;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Commercial;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.exception.web._417JobMethodException;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.BodyParam;

public class TypedArgument {
    public static Object analyzeJob(Envelop envelop, Class<?> type, Mission mission, Refer underway) {
        if (Envelop.class == type) {
            return envelop;
        }
        if (TypedArgument.is(type, Session.class)) {
            return envelop.session();
        }
        if (TypedArgument.is(type, User.class)) {
            return envelop.user();
        }
        if (TypedArgument.is(type, MultiMap.class)) {
            return envelop.headers();
        }
        if (TypedArgument.is(type, Commercial.class)) {
            JsonObject metadata = mission.getMetadata();
            String className = metadata.getString("_class");
            if (Ut.notNil((String)className)) {
                Commercial commercial = (Commercial)Ut.instance((String)className, (Object[])new Object[0]);
                commercial.fromJson(metadata);
                return commercial;
            }
            return null;
        }
        if (TypedArgument.is(type, JsonObject.class)) {
            if (type.isAnnotationPresent(BodyParam.class)) {
                return envelop.data();
            }
            return mission.getAdditional().copy();
        }
        if (TypedArgument.is(type, Mission.class)) {
            return mission;
        }
        if (TypedArgument.is(type, Refer.class)) {
            return underway;
        }
        throw new _417JobMethodException(TypedArgument.class, mission.getCode());
    }

    public static Object analyzeWorker(Envelop envelop, Class<?> type) {
        Object returnValue;
        RoutingContext context = envelop.context();
        if (TypedArgument.is(type, XHeader.class)) {
            MultiMap headers = envelop.headers();
            XHeader header = new XHeader();
            header.fromHeader(headers);
            returnValue = header;
        } else {
            returnValue = TypedArgument.is(type, Session.class) ? envelop.session() : (TypedArgument.is(type, HttpServerRequest.class) ? context.request() : (TypedArgument.is(type, HttpServerResponse.class) ? context.response() : (TypedArgument.is(type, Vertx.class) ? context.vertx() : (TypedArgument.is(type, EventBus.class) ? context.vertx().eventBus() : (TypedArgument.is(type, User.class) ? envelop.user() : null)))));
        }
        return returnValue;
    }

    public static Object analyzeAgent(RoutingContext context, Class<?> type) {
        Set uploads;
        Object returnValue = null;
        if (TypedArgument.is(type, XHeader.class)) {
            HttpServerRequest request = context.request();
            MultiMap headers = request.headers();
            XHeader header = new XHeader();
            header.fromHeader(headers);
            returnValue = header;
        } else if (TypedArgument.is(type, Session.class)) {
            returnValue = context.session();
        } else if (TypedArgument.is(type, HttpServerRequest.class)) {
            returnValue = context.request();
        } else if (TypedArgument.is(type, HttpServerResponse.class)) {
            returnValue = context.response();
        } else if (TypedArgument.is(type, Vertx.class)) {
            returnValue = context.vertx();
        } else if (TypedArgument.is(type, EventBus.class)) {
            returnValue = context.vertx().eventBus();
        } else if (TypedArgument.is(type, User.class)) {
            returnValue = context.user();
        } else if (TypedArgument.is(type, Set.class)) {
            returnValue = context.fileUploads();
        } else if (TypedArgument.is(type, JsonArray.class)) {
            returnValue = context.getBodyAsJsonArray();
            if (Objects.isNull(returnValue)) {
                returnValue = new JsonArray();
            }
        } else if (TypedArgument.is(type, JsonObject.class)) {
            returnValue = context.getBodyAsJson();
            if (Objects.isNull(returnValue)) {
                returnValue = new JsonObject();
            }
        } else if (TypedArgument.is(type, Buffer.class)) {
            returnValue = context.getBody();
            if (Objects.isNull(returnValue)) {
                returnValue = Buffer.buffer();
            }
        } else if (TypedArgument.is(type, FileUpload.class) && !(uploads = context.fileUploads()).isEmpty()) {
            returnValue = uploads.iterator().next();
        }
        return returnValue;
    }

    private static boolean is(Class<?> paramType, Class<?> expected) {
        return expected == paramType || Ut.isImplement(paramType, expected);
    }
}

