/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import io.vertx.up.atom.agent.Event;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.uca.web.thread.EndPointThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class EventInquirer
implements Inquirer<Set<Event>> {
    private static final Annal LOGGER = Annal.get(EventInquirer.class);

    @Override
    public Set<Event> scan(Set<Class<?>> endpoints) {
        ArrayList<EndPointThread> threadReference = new ArrayList<EndPointThread>();
        for (Class<?> endpoint : endpoints) {
            EndPointThread thread = new EndPointThread(endpoint);
            threadReference.add(thread);
            thread.start();
        }
        Fn.safeJvm(() -> {
            for (EndPointThread item : threadReference) {
                item.join();
            }
        }, (Annal)LOGGER);
        HashSet<Event> events = new HashSet<Event>();
        Fn.safeJvm(() -> {
            for (EndPointThread item : threadReference) {
                events.addAll(item.getEvents());
            }
        }, (Annal)LOGGER);
        return events;
    }
}

