/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.vertx.up.annotations.EndPoint;
import io.vertx.up.annotations.Queue;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.Infix;
import io.vertx.up.uca.di.JavaDi;
import io.vertx.up.uca.di.JsrDi;
import io.vertx.up.uca.web.filter.HttpFilter;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class GuiceInquirer
implements Inquirer<Injector> {
    private static final Annal LOGGER = Annal.get(GuiceInquirer.class);

    @Override
    public Injector scan(Set<Class<?>> clazzes) {
        LOGGER.info("[ DI ] The DI environment will be initialized!", new Object[0]);
        LOGGER.info("[ DI ] Start to parsing IMPL mode...", new Object[0]);
        ConcurrentHashMap implMap = new ConcurrentHashMap();
        clazzes.forEach(clazz -> {
            if (this.isValid((Class<?>)clazz) && !clazz.isInterface()) {
                Set interfaces = Arrays.stream(clazz.getInterfaces()).filter(item -> Serializable.class != item).collect(Collectors.toSet());
                if (0 == interfaces.size()) {
                    implMap.put(clazz, new HashSet<Class<?>>((Class)clazz){
                        final /* synthetic */ Class val$clazz;
                        {
                            this.val$clazz = clazz;
                            this.add(this.val$clazz);
                        }
                    });
                } else {
                    implMap.put(clazz, interfaces);
                }
            }
        });
        LOGGER.info("[ DI ] Start to parsing INTERFACE/INFIX mode...", new Object[0]);
        ConcurrentHashMap interfaceMap = new ConcurrentHashMap();
        ConcurrentHashMap infixMap = new ConcurrentHashMap();
        implMap.forEach((impl, interfaceSet) -> interfaceSet.forEach(interfaceCls -> {
            if (interfaceCls.isInterface()) {
                if (Infix.class == interfaceCls) {
                    infixMap.put(impl, interfaceCls);
                } else {
                    Set interfaceValue = interfaceMap.getOrDefault(interfaceCls, new HashSet());
                    interfaceValue.add(impl);
                    interfaceMap.put(interfaceCls, interfaceValue);
                }
            }
        }));
        LOGGER.info("[ DI ] Duplicated removing...", new Object[0]);
        interfaceMap.forEach((interfaceCls, implSet) -> {
            if (1 < implSet.size()) {
                implSet.forEach(implMap::remove);
            }
        });
        infixMap.keySet().forEach(implMap::remove);
        LOGGER.info("[ DI ] Calculate final size: IMPL = {0}, INTERFACE = {1}, INFIX = {2}", new Object[]{String.valueOf(implMap.size()), String.valueOf(interfaceMap.size()), String.valueOf(infixMap.size())});
        return Guice.createInjector((Module[])new Module[]{new JavaDi(implMap), new JsrDi(interfaceMap)});
    }

    private boolean isValid(Class<?> clazz) {
        int modifier = clazz.getModifiers();
        boolean valid = Modifier.isPublic(modifier);
        if (Modifier.isAbstract(modifier) && !clazz.isInterface()) {
            valid = false;
        }
        if (clazz.isAnnotationPresent(EndPoint.class) || clazz.isAnnotationPresent(Queue.class)) {
            valid = false;
        }
        if (!Ut.withNoArgConstructor(clazz)) {
            valid = false;
        }
        if (AbstractModule.class.isAssignableFrom(clazz)) {
            valid = false;
        }
        if (HttpFilter.class.isAssignableFrom(clazz)) {
            valid = false;
        }
        return valid;
    }
}

