/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.web.origin;

import io.reactivex.Observable;
import io.vertx.up.annotations.EndPoint;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.web.origin.Inquirer;
import io.vertx.up.util.Ut;
import io.vertx.zero.exception.IpcMethodArgException;
import io.vertx.zero.exception.IpcMethodReturnException;
import io.vertx.zero.exception.IpcMethodTargetException;
import io.vertx.zero.exception.RpcAgentAbsenceException;
import io.vertx.zero.exception.UnknownDirectionException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IpcInquirer
implements Inquirer<ConcurrentMap<String, Method>> {
    private static final Annal LOGGER = Annal.get(IpcInquirer.class);

    @Override
    public ConcurrentMap<String, Method> scan(Set<Class<?>> classes) {
        ConcurrentHashMap<String, Method> addresses = new ConcurrentHashMap<String, Method>();
        Observable.fromIterable(classes).flatMap(clazz -> Observable.fromArray((Object[])clazz.getDeclaredMethods())).filter(Objects::nonNull).filter(method -> method.isAnnotationPresent(Ipc.class)).map(this::ensureTarget).map(this::ensureSpec).map(method -> this.ensureAgent((Method)method, classes)).subscribe(method -> {
            Ipc annotation = method.getAnnotation(Ipc.class);
            String address = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            addresses.put(address, (Method)method);
        }).dispose();
        return addresses;
    }

    private Method ensureSpec(Method method) {
        Fn.outUp((boolean)Ut.isVoid(method.getReturnType()), (Annal)LOGGER, IpcMethodReturnException.class, (Object[])new Object[]{this.getClass(), method});
        Ipc annotation = method.getAnnotation(Ipc.class);
        String value = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        if (!Ut.isNil((String)value)) {
            Class<?>[] argTypes = method.getParameterTypes();
            Fn.outUp((1 != argTypes.length || Envelop.class != argTypes[0] ? 1 : 0) != 0, (Annal)LOGGER, IpcMethodArgException.class, (Object[])new Object[]{this.getClass(), method});
        }
        return method;
    }

    private Method ensureAgent(Method method, Set<Class<?>> classes) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isAnnotationPresent(EndPoint.class) && clazz.isInterface()) {
            Long counter = (Long)Observable.fromIterable(classes).filter(item -> clazz != item).filter(clazz::isAssignableFrom).count().blockingGet();
            Fn.outUp((0L == counter ? 1 : 0) != 0, (Annal)LOGGER, RpcAgentAbsenceException.class, (Object[])new Object[]{this.getClass(), clazz});
        }
        return method;
    }

    private Method ensureTarget(Method method) {
        Ipc annotation = method.getAnnotation(Ipc.class);
        String to = (String)Ut.invoke((Object)annotation, (String)"to", (Object[])new Object[0]);
        String name = (String)Ut.invoke((Object)annotation, (String)"name", (Object[])new Object[0]);
        if (Ut.isNil((String)to) && Ut.isNil((String)name)) {
            String from = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            Fn.outUp((boolean)Ut.isNil((String)from), (Annal)LOGGER, UnknownDirectionException.class, (Object[])new Object[]{this.getClass(), method});
            return method;
        }
        Fn.outUp((Ut.isNil((String)to) || Ut.isNil((String)name) ? 1 : 0) != 0, (Annal)LOGGER, IpcMethodTargetException.class, (Object[])new Object[]{this.getClass(), method, to, name});
        return method;
    }
}

