/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.reactivex.Observable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._400SigmaMissingException;
import io.vertx.up.unity.To;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

class Combine {
    Combine() {
    }

    static <T> Future<List<T>> thenCombineT(List<Future<T>> futures) {
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(futures);
        return CompositeFuture.join(futureList).compose(finished -> {
            ArrayList result = new ArrayList();
            Ut.itList((List)finished.list(), (item, index) -> result.add(item));
            return Future.succeededFuture(result);
        });
    }

    static <T> Future<List<T>> thenCombineArrayT(List<Future<List<T>>> futures) {
        ArrayList<Future<List<T>>> futureList = new ArrayList<Future<List<T>>>(futures);
        return CompositeFuture.join(futureList).compose(finished -> {
            ArrayList result = new ArrayList();
            if (null != finished) {
                Ut.itList((List)finished.list(), (item, index) -> {
                    List grouped;
                    if (item instanceof List && !(grouped = (List)item).isEmpty()) {
                        result.addAll(grouped);
                    }
                });
            }
            return Future.succeededFuture(result);
        });
    }

    static Future<JsonArray> thenCombine(Future<JsonArray> source, Function<JsonObject, Future<JsonObject>> generateFun, BinaryOperator<JsonObject> operatorFun) {
        return source.compose(first -> {
            ArrayList secondFutures = new ArrayList();
            Observable.fromIterable((Iterable)first).map(item -> (JsonObject)item).map(generateFun::apply).subscribe(secondFutures::add).dispose();
            return CompositeFuture.join(secondFutures).compose(finished -> {
                List secondary = finished.list();
                List completed = Ut.elementZip((List)first.getList(), (List)secondary, (BiFunction)operatorFun);
                return Ux.future(new JsonArray(completed));
            });
        });
    }

    static Future<JsonObject> thenCombine(Future<JsonObject> ... futures) {
        return CompositeFuture.join(Arrays.asList(futures)).compose(finished -> {
            JsonObject resultMap = new JsonObject();
            if (null != finished) {
                Ut.itList((List)finished.list(), (item, index) -> resultMap.put(index.toString(), item));
            }
            return Future.succeededFuture((Object)resultMap);
        });
    }

    static <K, T> Future<ConcurrentMap<K, T>> thenCombine(ConcurrentMap<K, Future<T>> futureMap) {
        ArrayList keys = new ArrayList();
        ArrayList futures = new ArrayList();
        futureMap.forEach((key, future) -> {
            keys.add(key);
            futures.add(future);
        });
        return CompositeFuture.join(futures).compose(finished -> {
            List list = finished.list();
            int size = list.size();
            ConcurrentHashMap resultMap = new ConcurrentHashMap();
            for (int idx = 0; idx < size; ++idx) {
                Object key = keys.get(idx);
                Object result = list.get(idx);
                if (!Objects.nonNull(key) || !Objects.nonNull(result)) continue;
                resultMap.put(key, result);
            }
            return Future.succeededFuture(resultMap);
        });
    }

    static Future<JsonArray> thenCombineArray(List<Future<JsonArray>> futures) {
        ArrayList<Future<JsonArray>> futureList = new ArrayList<Future<JsonArray>>(futures);
        return CompositeFuture.join(futureList).compose(finished -> {
            JsonArray resultMap = new JsonArray();
            if (null != finished) {
                Ut.itList((List)finished.list(), (item, index) -> {
                    if (item instanceof JsonArray) {
                        resultMap.addAll((JsonArray)item);
                    }
                });
            }
            return Future.succeededFuture((Object)resultMap);
        });
    }

    static Future<JsonObject> thenCombine(Future<JsonObject> source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return source.compose(first -> CompositeFuture.join((List)((List)generateFun.apply((JsonObject)first))).compose(finished -> {
            if (null != finished) {
                List secondary = finished.list();
                Ut.itList((List)secondary, (item, index) -> operatorFun[index].accept(first, item));
            }
            return Future.succeededFuture((Object)first);
        }));
    }

    static Future<JsonArray> thenCombine(List<Future<JsonObject>> futures) {
        return CompositeFuture.join(new ArrayList<Future<JsonObject>>(futures)).compose(finished -> {
            JsonArray result = null == finished ? new JsonArray() : new JsonArray(finished.list());
            return Future.succeededFuture((Object)result);
        });
    }

    static <F, S, T> Future<T> thenCombine(Supplier<Future<F>> futureF, Supplier<Future<S>> futureS, BiFunction<F, S, Future<T>> consumer) {
        return futureF.get().compose(f -> ((Future)futureS.get()).compose(s -> (Future)consumer.apply(f, s)));
    }

    static <T> Future<T> thenError(Class<? extends WebException> clazz, Object ... args) {
        WebException error = To.toError(clazz, args);
        return Future.failedFuture((Throwable)error);
    }

    static <T> Future<T> thenErrorSigma(Class<?> clazz, String sigma, Supplier<Future<T>> supplier) {
        if (Ut.isNil((String)sigma)) {
            _400SigmaMissingException error = new _400SigmaMissingException(clazz);
            return Future.failedFuture((Throwable)error);
        }
        return supplier.get();
    }

    static <T> Future<ConcurrentMap<String, T>> thenCompress(List<Future<ConcurrentMap<String, T>>> futures, BinaryOperator<T> binaryOperator) {
        return CompositeFuture.join(new ArrayList<Future<ConcurrentMap<String, T>>>(futures)).compose(finished -> {
            ConcurrentHashMap resultMap = new ConcurrentHashMap();
            if (Objects.nonNull(finished)) {
                List result = finished.list();
                BinaryOperator mergeOperator = Objects.isNull(binaryOperator) ? (original, latest) -> latest : binaryOperator;
                result.stream().filter(Objects::nonNull).forEach(each -> each.keySet().stream().filter(key -> Objects.nonNull(each.get(key))).forEach(key -> {
                    Object combined;
                    if (resultMap.containsKey(key)) {
                        Object original = resultMap.get(key);
                        Object latest = each.get(key);
                        combined = mergeOperator.apply(original, latest);
                    } else {
                        combined = each.get(key);
                    }
                    resultMap.put(key, combined);
                }));
            }
            return Future.succeededFuture(resultMap);
        });
    }
}

