/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;

class CompareJ {
    private static final Annal LOGGER = Annal.get(CompareJ.class);

    CompareJ() {
    }

    static JsonArray ruleJReduce(JsonArray records, JsonArray matrix) {
        JsonArray normalized = new JsonArray();
        Ut.itJArray((JsonArray)records).filter(json -> CompareJ.ruleJOk(json, matrix)).forEach(arg_0 -> ((JsonArray)normalized).add(arg_0));
        return normalized;
    }

    static JsonArray ruleJReduce(JsonArray records, Set<String> fields) {
        JsonArray normalized = new JsonArray();
        Ut.itJArray((JsonArray)records).filter(json -> CompareJ.ruleJOk(json, fields)).forEach(arg_0 -> ((JsonArray)normalized).add(arg_0));
        return normalized;
    }

    static boolean ruleJOk(JsonObject record, Set<String> fields) {
        return fields.stream().allMatch(field -> Objects.nonNull(record.getValue(field)));
    }

    static boolean ruleJOk(JsonObject record, JsonArray matrix) {
        int size = matrix.size();
        for (int idx = 0; idx < size; ++idx) {
            Object value = matrix.getValue(idx);
            Set<String> fields = CompareJ.fieldSet(value);
            if (fields.isEmpty()) {
                return false;
            }
            boolean match = CompareJ.ruleJOk(record, fields);
            if (match) continue;
            return false;
        }
        return true;
    }

    static boolean ruleJEqual(JsonObject record, JsonObject latest, JsonArray matrix) {
        int size = matrix.size();
        for (int idx = 0; idx < size; ++idx) {
            boolean equal;
            Object value = matrix.getValue(idx);
            Set<String> fields = CompareJ.fieldSet(value);
            if (fields.isEmpty() || !(equal = CompareJ.ruleJEqual(record, latest, fields))) continue;
            return true;
        }
        return false;
    }

    static boolean ruleJEqual(JsonObject record, JsonObject latest, Set<String> fields) {
        JsonObject subR = Ut.elementSubset((JsonObject)record, fields);
        JsonObject subL = Ut.elementSubset((JsonObject)latest, fields);
        return subR.equals((Object)subL);
    }

    static JsonObject ruleJFind(JsonArray source, JsonObject expected, Set<String> fields) {
        return Ut.itJArray((JsonArray)source).filter(json -> CompareJ.ruleJEqual(json, expected, fields)).findAny().orElse(new JsonObject());
    }

    static JsonObject ruleJFind(JsonArray source, JsonObject expected, JsonArray matrix) {
        return Ut.itJArray((JsonArray)source).filter(json -> CompareJ.ruleJEqual(json, expected, matrix)).findAny().orElse(new JsonObject());
    }

    private static Set<String> fieldSet(Object value) {
        HashSet<String> fields;
        if (value instanceof JsonArray) {
            fields = Ut.toSet((JsonArray)((JsonArray)value));
        } else if (value instanceof String) {
            fields = new HashSet<String>();
            fields.add((String)value);
        } else {
            fields = new HashSet();
        }
        return fields;
    }

    static ConcurrentMap<ChangeFlag, JsonArray> compareJ(JsonArray original, JsonArray current, Set<String> fields) {
        return CompareJ.compareJ(original, current, (JsonArray source, JsonObject record) -> CompareJ.ruleJFind(source, record, fields));
    }

    static ConcurrentMap<ChangeFlag, JsonArray> compareJ(JsonArray original, JsonArray current, JsonArray matrix) {
        return CompareJ.compareJ(original, current, (JsonArray source, JsonObject record) -> CompareJ.ruleJFind(source, record, matrix));
    }

    private static ConcurrentMap<ChangeFlag, JsonArray> compareJ(JsonArray original, JsonArray current, BiFunction<JsonArray, JsonObject, JsonObject> findFn) {
        ConcurrentHashMap<ChangeFlag, JsonArray> result = new ConcurrentHashMap<ChangeFlag, JsonArray>();
        result.put(ChangeFlag.UPDATE, new JsonArray());
        result.put(ChangeFlag.ADD, new JsonArray());
        result.put(ChangeFlag.DELETE, new JsonArray());
        Ut.itJArray((JsonArray)original).forEach(recordO -> {
            JsonObject recordN = (JsonObject)findFn.apply(current, (JsonObject)recordO);
            if (Ut.isNil((JsonObject)recordN)) {
                ((JsonArray)result.get(ChangeFlag.DELETE)).add(recordO);
            } else {
                JsonObject recordNC = recordN.copy();
                if (recordNC.containsKey("key")) {
                    recordNC.remove("key");
                }
                JsonObject combine = recordO.copy().mergeIn(recordNC, true);
                ((JsonArray)result.get(ChangeFlag.UPDATE)).add((Object)combine);
            }
        });
        Ut.itJArray((JsonArray)current).forEach(recordN -> {
            JsonObject recordO = (JsonObject)findFn.apply(original, (JsonObject)recordN);
            if (Ut.isNil((JsonObject)recordO)) {
                ((JsonArray)result.get(ChangeFlag.ADD)).add(recordN);
            }
        });
        return result;
    }
}

