/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.query.Pagination;
import io.vertx.up.unity.To;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

class Complex {
    Complex() {
    }

    static <T> Future<T> complex(T input, Predicate<T> predicate, Supplier<Future<T>> executor) {
        if (Objects.isNull(input)) {
            return To.future(null);
        }
        if (Objects.isNull(executor)) {
            return To.future(input);
        }
        if (Objects.isNull(predicate)) {
            return executor.get();
        }
        if (predicate.test(input)) {
            return executor.get();
        }
        return To.future(input);
    }

    static <T, R> Future<R> complex(Pagination first, Function<T, Future<Integer>> totalConsumer, Function<Pagination, Future<T>> pageConsumer, Function<T, Future<R>> responseBuilder, BinaryOperator<R> fnReduce) {
        Refer firstResult = new Refer();
        return pageConsumer.apply(first).compose(response -> ((Future)responseBuilder.apply(response)).compose(arg_0 -> ((Refer)firstResult).future(arg_0)).compose(nil -> (Future)totalConsumer.apply(response)).compose(total -> {
            first.setTotal(total);
            return Ux.future(first);
        })).compose(Pagination::scatterAsync).compose(pageSet -> {
            if (pageSet.isEmpty()) {
                return Ux.future(firstResult.get());
            }
            ArrayList futures = new ArrayList();
            pageSet.stream().map(each -> ((Future)pageConsumer.apply((Pagination)each)).compose(responseBuilder)).forEach(futures::add);
            return Ux.thenCombineT(futures).compose(list -> {
                Object result = list.stream().reduce(fnReduce).orElse(null);
                Object firstRef = firstResult.get();
                return Ux.future(fnReduce.apply(firstRef, result));
            });
        }).otherwise(Ux.otherwise(() -> null));
    }

    static Function<Pagination, Future<JsonArray>> complex(Function<JsonObject, Future<Integer>> total, Function<Pagination, Future<JsonObject>> page, Function<JsonObject, Future<JsonArray>> result) {
        return first -> Complex.complex(first, total, page, result, JsonArray::addAll);
    }
}

