/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.up.commune.Envelop;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.UxJwt;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

class In {
    In() {
    }

    static <T> T request(Message<Envelop> message, Class<T> clazz) {
        Envelop body = (Envelop)message.body();
        return In.request(body, clazz);
    }

    static <T> T request(Envelop envelop, Class<T> clazz) {
        return (T)Fn.getSemi((null == envelop ? 1 : 0) != 0, null, () -> null, () -> envelop.data(clazz));
    }

    static <T> T request(Message<Envelop> message, Integer index, Class<T> clazz) {
        Envelop body = (Envelop)message.body();
        return In.request(body, index, clazz);
    }

    static <T> T request(Envelop envelop, Integer index, Class<T> clazz) {
        return (T)Fn.getSemi((null == envelop ? 1 : 0) != 0, null, () -> null, () -> envelop.data(index, clazz));
    }

    static String requestUser(Message<Envelop> message, String field) {
        return In.requestUser((Envelop)message.body(), field);
    }

    static String requestUser(Envelop envelop, String field) {
        return (String)Fn.getSemi((null == envelop ? 1 : 0) != 0, null, () -> null, () -> envelop.identifier(field));
    }

    static String requestTokenData(String tokenString, String field) {
        JsonObject token;
        String result = null;
        if (Ut.notNil((String)tokenString) && Objects.nonNull(token = UxJwt.extract(tokenString))) {
            result = token.getString(field);
        }
        return result;
    }

    static Object requestSession(Message<Envelop> message, String field) {
        return In.requestSession((Envelop)message.body(), field);
    }

    static Object requestSession(Envelop envelop, String field) {
        return Fn.getSemi((null == envelop ? 1 : 0) != 0, null, () -> null, () -> {
            Session session = envelop.session();
            return null == session ? null : session.get(field);
        });
    }

    static JsonArray assignValue(JsonArray source, JsonArray target, String field, boolean override) {
        Ut.itJArray((JsonArray)source, JsonObject.class, (item, index) -> {
            if (override) {
                item.put(field, target.getValue(index.intValue()));
            } else if (!item.containsKey(field)) {
                item.put(field, target.getValue(index.intValue()));
            }
        });
        return source;
    }

    static void assignAuditor(Object reference, boolean isUpdate) {
        if (Objects.nonNull(reference) && reference instanceof Envelop) {
            Envelop envelop = (Envelop)reference;
            String user = In.requestUser(envelop, "user");
            if (isUpdate) {
                envelop.value("updateBy", user);
                envelop.value("udpateTime", Instant.now());
            } else {
                envelop.value("key", UUID.randomUUID().toString());
                envelop.value("createBy", user);
                envelop.value("createTime", Instant.now());
            }
        }
    }
}

