/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.record.Apt;
import io.vertx.up.commune.rule.RuleTerm;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;

class Unique {
    private Unique() {
    }

    static JsonObject ruleAll(Collection<RuleTerm> rules, JsonObject input) {
        boolean isMatch = rules.stream().allMatch(term -> Objects.nonNull(term.dataMatch(input)));
        return isMatch ? input : null;
    }

    static JsonObject ruleAll(Collection<RuleTerm> rules, JsonObject recordO, JsonObject recordN) {
        boolean isMatch = rules.stream().allMatch(rule -> Unique.ruleMatch(rule, recordO, recordN));
        return isMatch ? Unique.ruleTwins(recordO, recordN) : null;
    }

    static JsonObject ruleAll(Collection<RuleTerm> rules, JsonArray source, JsonObject record) {
        return Ut.itJArray((JsonArray)source).map(recordR -> Unique.ruleAll(rules, record, recordR)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static JsonObject ruleAny(Collection<RuleTerm> rules, JsonObject input) {
        boolean isMatch = rules.stream().anyMatch(term -> Objects.nonNull(term.dataMatch(input)));
        return isMatch ? input : null;
    }

    static JsonObject ruleAny(Collection<RuleTerm> rules, JsonObject recordO, JsonObject recordN) {
        boolean isMatch = rules.stream().anyMatch(rule -> Unique.ruleMatch(rule, recordO, recordN));
        return isMatch ? Unique.ruleTwins(recordO, recordN) : null;
    }

    static JsonObject ruleAny(Collection<RuleTerm> rules, JsonArray source, JsonObject record) {
        return Ut.itJArray((JsonArray)source).map(recordR -> Unique.ruleAny(rules, record, recordR)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static ConcurrentMap<Boolean, JsonArray> ruleAll(Collection<RuleTerm> rules, JsonArray input) {
        return Unique.ruleSplit(rules, input, Unique::ruleAll);
    }

    static ConcurrentMap<Boolean, JsonArray> ruleAny(Collection<RuleTerm> rules, JsonArray input) {
        return Unique.ruleSplit(rules, input, Unique::ruleAny);
    }

    static JsonObject ruleTwins(JsonObject recordO, JsonObject recordN) {
        JsonObject data = new JsonObject();
        data.put("__OLD__", (Object)recordO);
        data.put("__NEW__", (Object)recordN);
        return data;
    }

    static Apt ruleApt(JsonArray twins, boolean isReplaced) {
        JsonArray oldQueue = new JsonArray();
        JsonArray newQueue = new JsonArray();
        JsonArray updatedQueue = new JsonArray();
        JsonArray addQueue = new JsonArray();
        Ut.itJArray((JsonArray)twins).forEach(json -> {
            JsonObject oldRecord = json.getJsonObject("__OLD__");
            JsonObject newRecord = json.getJsonObject("__NEW__");
            if (Objects.nonNull(oldRecord) && Objects.nonNull(newRecord)) {
                oldQueue.add((Object)oldRecord);
                newQueue.add((Object)newRecord);
                if (isReplaced) {
                    updatedQueue.add((Object)oldRecord.copy().mergeIn(newRecord, true));
                } else {
                    JsonObject merged = oldRecord.copy();
                    newRecord.fieldNames().stream().filter(key -> Objects.nonNull(newRecord.getValue(key))).forEach(key -> merged.put(key, newRecord.getValue(key)));
                    updatedQueue.add((Object)merged);
                }
            }
            if (Objects.nonNull(oldRecord) && Objects.isNull(newRecord)) {
                oldQueue.add((Object)oldRecord);
            }
            if (Objects.isNull(oldRecord) && Objects.nonNull(newRecord)) {
                newQueue.add((Object)newRecord);
                addQueue.add((Object)newRecord);
            }
        });
        Apt apt = Apt.create((JsonArray)oldQueue, (JsonArray)newQueue);
        if (!addQueue.isEmpty()) {
            apt.comparedA(addQueue);
        }
        if (!updatedQueue.isEmpty()) {
            apt.comparedU(updatedQueue);
        }
        return apt;
    }

    static JsonObject ruleNil(JsonObject twins, ChangeFlag flag) {
        JsonObject oldRecord = twins.getJsonObject("__OLD__");
        JsonObject newRecord = twins.getJsonObject("__NEW__");
        JsonObject normalized = new JsonObject();
        if (ChangeFlag.ADD == flag) {
            normalized.mergeIn(Objects.isNull(newRecord) ? oldRecord : newRecord, true);
        } else if (ChangeFlag.DELETE == flag) {
            normalized.mergeIn(Objects.isNull(oldRecord) ? newRecord : oldRecord, true);
        } else if (ChangeFlag.UPDATE == flag) {
            normalized.mergeIn(oldRecord.copy(), true);
            normalized.mergeIn(newRecord.copy(), true);
        }
        return normalized;
    }

    private static boolean ruleMatch(RuleTerm rule, JsonObject recordL, JsonObject recordR) {
        if (Objects.isNull(rule)) {
            return recordL.equals((Object)recordR);
        }
        JsonObject recordLR = rule.dataRule(recordL);
        JsonObject recordRR = rule.dataRule(recordR);
        if (Ut.isNil((JsonObject)recordLR) || Ut.isNil((JsonObject)recordRR)) {
            return false;
        }
        return recordLR.equals((Object)recordRR);
    }

    private static ConcurrentMap<Boolean, JsonArray> ruleSplit(Collection<RuleTerm> rules, JsonArray input, BiFunction<Collection<RuleTerm>, JsonObject, JsonObject> eachFn) {
        final JsonArray valid = new JsonArray();
        final JsonArray inValid = new JsonArray();
        Ut.itJArray((JsonArray)input).forEach(item -> {
            JsonObject validItem = (JsonObject)eachFn.apply(rules, (JsonObject)item);
            if (Objects.isNull(validItem)) {
                inValid.add(item);
            } else {
                valid.add((Object)validItem);
            }
        });
        return new ConcurrentHashMap<Boolean, JsonArray>(){
            {
                this.put(Boolean.TRUE, valid);
                this.put(Boolean.FALSE, inValid);
            }
        };
    }
}

