/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.tp.plugin.jooq.JooqDsl;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.atom.query.Pagination;
import io.vertx.up.atom.record.Apt;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.Record;
import io.vertx.up.commune.exchange.DiConsumer;
import io.vertx.up.commune.exchange.DiFabric;
import io.vertx.up.commune.exchange.DiSetting;
import io.vertx.up.commune.rule.RuleTerm;
import io.vertx.up.eon.em.AuthWall;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Fn;
import io.vertx.up.fn.wait.Log;
import io.vertx.up.secure.Lee;
import io.vertx.up.secure.LeeBuiltIn;
import io.vertx.up.uca.jooq.UxJoin;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Async;
import io.vertx.up.unity.Atomic;
import io.vertx.up.unity.Cache;
import io.vertx.up.unity.Combine;
import io.vertx.up.unity.Compare;
import io.vertx.up.unity.CompareJ;
import io.vertx.up.unity.Complex;
import io.vertx.up.unity.Debug;
import io.vertx.up.unity.DiTool;
import io.vertx.up.unity.From;
import io.vertx.up.unity.In;
import io.vertx.up.unity.To;
import io.vertx.up.unity.Unique;
import io.vertx.up.unity.Upload;
import io.vertx.up.unity.UxJob;
import io.vertx.up.unity.UxOpt;
import io.vertx.up.unity.UxPool;
import io.vertx.up.unity.UxTimer;
import io.vertx.up.unity.Web;
import io.vertx.up.unity.Where;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Ux {
    public static JsonObject outBool(boolean checked) {
        return Async.bool("result", checked);
    }

    public static JsonObject outBool(String key, boolean checked) {
        return Async.bool(key, checked);
    }

    public static Log log(Class<?> clazz) {
        return Log.create(null == clazz ? Ux.class : clazz);
    }

    public static void debug(Object ... objects) {
        Debug.monitor(objects);
    }

    public static <T> Future<T> debug(T item) {
        return Debug.debug(item);
    }

    public static <T> T debug(Throwable error, Supplier<T> supplier) {
        return Debug.debug(error, supplier);
    }

    public static Function<Throwable, Envelop> otherwise() {
        return Debug.otherwise();
    }

    public static <T> Function<Throwable, T> otherwise(Supplier<T> supplier) {
        return Debug.otherwise(supplier);
    }

    public static <T> Function<Throwable, T> otherwise(T input) {
        return Ux.otherwise(() -> input);
    }

    public static JsonObject ruleAll(Collection<RuleTerm> rules, JsonObject input) {
        return Unique.ruleAll(rules, input);
    }

    public static ConcurrentMap<Boolean, JsonArray> ruleAll(Collection<RuleTerm> rules, JsonArray input) {
        return Unique.ruleAll(rules, input);
    }

    public static JsonObject ruleAll(Collection<RuleTerm> rules, JsonObject recordO, JsonObject recordN) {
        return Unique.ruleAll(rules, recordO, recordN);
    }

    public static JsonObject ruleAll(Collection<RuleTerm> rules, JsonArray source, JsonObject record) {
        return Unique.ruleAll(rules, source, record);
    }

    public static JsonObject ruleAny(Collection<RuleTerm> rules, JsonObject input) {
        return Unique.ruleAny(rules, input);
    }

    public static JsonObject ruleAny(Collection<RuleTerm> rules, JsonObject record0, JsonObject recordN) {
        return Unique.ruleAny(rules, record0, recordN);
    }

    public static JsonObject ruleAny(Collection<RuleTerm> rules, JsonArray source, JsonObject record) {
        return Unique.ruleAny(rules, source, record);
    }

    public static ConcurrentMap<Boolean, JsonArray> ruleAny(Collection<RuleTerm> rules, JsonArray input) {
        return Unique.ruleAny(rules, input);
    }

    public static JsonObject ruleTwins(JsonObject recordO, JsonObject recordN) {
        return Unique.ruleTwins(recordO, recordN);
    }

    public static JsonObject ruleNil(JsonObject twins, ChangeFlag flag) {
        return Unique.ruleNil(twins, flag);
    }

    public static JsonObject ruleNil(JsonObject recordN, JsonObject recordO) {
        return Objects.isNull(recordN) ? recordO : recordN;
    }

    public static Apt ruleApt(JsonArray twins, boolean isReplaced) {
        return Unique.ruleApt(twins, isReplaced);
    }

    public static boolean ruleJOk(JsonObject record, Set<String> fields) {
        return CompareJ.ruleJOk(record, fields);
    }

    public static boolean ruleJOk(JsonObject record, JsonArray matrix) {
        return CompareJ.ruleJOk(record, matrix);
    }

    public static JsonArray ruleJReduce(JsonArray records, Set<String> fields) {
        return CompareJ.ruleJReduce(records, fields);
    }

    public static JsonArray ruleJReduce(JsonArray records, JsonArray matrix) {
        return CompareJ.ruleJReduce(records, matrix);
    }

    public static boolean ruleJEqual(JsonObject record, JsonObject latest, Set<String> fields) {
        return CompareJ.ruleJEqual(record, latest, fields);
    }

    public static boolean ruleJEqual(JsonObject record, JsonObject latest, JsonArray matrix) {
        return CompareJ.ruleJEqual(record, latest, matrix);
    }

    public static JsonObject ruleJFind(JsonArray source, JsonObject expected, Set<String> fields) {
        return CompareJ.ruleJFind(source, expected, fields);
    }

    public static JsonObject ruleJFind(JsonArray source, JsonObject expected, JsonArray matrix) {
        return CompareJ.ruleJFind(source, expected, matrix);
    }

    public static <T> JsonObject toJson(T entity) {
        return To.toJObject(entity, "");
    }

    public static <T> JsonObject toJson(T entity, String pojo) {
        return To.toJObject(entity, pojo);
    }

    public static <T> JsonArray toJson(List<T> list) {
        return To.toJArray(list, "");
    }

    public static <T> JsonArray toJson(List<T> list, String pojo) {
        return To.toJArray(list, pojo);
    }

    public static JsonObject toZip(Object ... args) {
        return To.toToggle(args);
    }

    public static <T> T fromJson(JsonObject data, Class<T> clazz) {
        return From.fromJson(data, clazz, "");
    }

    public static <T> List<T> fromJson(JsonArray array, Class<T> clazz) {
        return From.fromJson(array, clazz, "");
    }

    public static <T> List<T> fromPage(JsonObject data, Class<T> clazz) {
        return Ux.fromJson(Ux.pageData(data), clazz);
    }

    public static <T> T fromJson(JsonObject data, Class<T> clazz, String pojo) {
        return From.fromJson(data, clazz, pojo);
    }

    public static <T> List<T> fromJson(JsonArray array, Class<T> clazz, String pojo) {
        return From.fromJson(array, clazz, pojo);
    }

    public static JsonObject criteria(JsonObject data, String pojo) {
        return From.fromJson(data, pojo);
    }

    public static <T> T toFile(Set<FileUpload> fileUploads, Class<?> expected, Function<String, Buffer> consumer) {
        return Upload.toFile(fileUploads, expected, consumer);
    }

    public static <T> T toFile(FileUpload fileUpload, Class<?> expected, Function<String, Buffer> consumer) {
        return Upload.toFile(fileUpload, expected, consumer);
    }

    public static ConcurrentMap<String, Set<FileUpload>> toFile(Set<FileUpload> fileUploads) {
        return Upload.toFile(fileUploads);
    }

    public static Envelop fromEnvelop(Class<? extends WebException> clazz, Object ... args) {
        return To.toEnvelop(clazz, args);
    }

    public static <T> Envelop fromEnvelop(T entity) {
        return To.toEnvelop(entity);
    }

    public static <T> Envelop fromEnvelop(T entity, WebException error) {
        return To.toEnvelop(entity, error);
    }

    public static <T> Future<T> fromAsync(CompletionStage<T> state) {
        return Async.fromAsync(state);
    }

    public static <T> Future<T> future(T entity) {
        return To.future(entity);
    }

    public static <T> Future<T> future(T input, List<Function<T, Future<T>>> functions) {
        return Async.future(input, functions);
    }

    public static <T> Future<T> future(T input, Set<Function<T, Future<T>>> functions) {
        return Async.future(input, functions);
    }

    public static <T> Future<T> future() {
        return To.future(null);
    }

    public static Future<JsonObject> complex(JsonObject input, Predicate<JsonObject> predicate, Supplier<Future<JsonObject>> executor) {
        return Complex.complex(input, predicate, executor);
    }

    public static Future<JsonArray> complex(Pagination first, Function<JsonObject, Future<Integer>> total, Function<Pagination, Future<JsonObject>> page, Function<JsonObject, Future<JsonArray>> result) {
        return Complex.complex(first, total, page, result, JsonArray::addAll);
    }

    public static Function<Pagination, Future<JsonArray>> complex(Function<JsonObject, Future<Integer>> total, Function<Pagination, Future<JsonObject>> page, Function<JsonObject, Future<JsonArray>> result) {
        return Complex.complex(total, page, result);
    }

    public static Function<Pagination, Future<JsonArray>> complex(Function<Pagination, Future<JsonObject>> page) {
        return Ux.complex((JsonObject data) -> To.future(data.getInteger("count")), page, (JsonObject response) -> To.future(response.getJsonArray("list")));
    }

    public static <T> Handler<AsyncResult<T>> handler(Message<Envelop> message) {
        return Web.toHandler(message);
    }

    public static <T> Future<T> handler(Consumer<Handler<AsyncResult<T>>> handler) {
        return Web.toFuture(handler);
    }

    public static <T, R> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Function<T, R> fnValue, String pojoFile) {
        return Compare.compare(original, current, fnValue, pojoFile);
    }

    public static <T, R> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Function<T, R> fnValue) {
        return Compare.compare(original, current, fnValue, "");
    }

    public static <T, R> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Set<String> uniqueSet, String pojoFile) {
        return Compare.compare(original, current, uniqueSet, pojoFile);
    }

    public static <T, R> ConcurrentMap<ChangeFlag, List<T>> compare(List<T> original, List<T> current, Set<String> uniqueSet) {
        return Compare.compare(original, current, uniqueSet, "");
    }

    public static ConcurrentMap<ChangeFlag, JsonArray> compareJ(JsonArray original, JsonArray current, Set<String> fields) {
        return CompareJ.compareJ(original, current, fields);
    }

    public static Future<ConcurrentMap<ChangeFlag, JsonArray>> compareJAsync(JsonArray original, JsonArray current, Set<String> fields) {
        return To.future(CompareJ.compareJ(original, current, fields));
    }

    public static ConcurrentMap<ChangeFlag, JsonArray> compareJ(JsonArray original, JsonArray current, JsonArray matrix) {
        return CompareJ.compareJ(original, current, matrix);
    }

    public static Future<ConcurrentMap<ChangeFlag, JsonArray>> compareJAsync(JsonArray original, JsonArray current, JsonArray matrix) {
        return To.future(CompareJ.compareJ(original, current, matrix));
    }

    public static Future<JsonObject> futureB(boolean checked) {
        return To.future(Ux.outBool(checked));
    }

    public static Future<Boolean> futureB(JsonObject checked) {
        return To.future(Async.bool(checked));
    }

    public static Future<JsonObject> futureJA(JsonArray array) {
        return To.future(Async.array(array));
    }

    public static <T> Function<Throwable, Future<T>> futureE(T input) {
        return Async.toErrorFuture(() -> input);
    }

    public static <T> Function<Throwable, Future<T>> futureE(Supplier<T> supplier) {
        return Async.toErrorFuture(supplier);
    }

    public static <T> Future<JsonArray> futureA(List<T> list, String pojo) {
        return Future.succeededFuture((Object)To.toJArray(list, pojo));
    }

    public static Future<JsonArray> futureA() {
        return Ux.futureA(new ArrayList(), "");
    }

    public static Future<JsonArray> futureA(Throwable ex) {
        return Async.toErrorFuture(JsonArray::new).apply(ex);
    }

    public static <T> Future<JsonArray> futureA(List<T> list) {
        return Ux.futureA(list, "");
    }

    public static <T> Function<List<T>, Future<JsonArray>> futureA(String pojo) {
        return list -> Ux.futureA(list, pojo);
    }

    public static <T> Future<JsonObject> futureJ(T entity, String pojo) {
        return Future.succeededFuture((Object)To.toJObject(entity, pojo));
    }

    public static <T, R> Function<List<R>, Future<JsonObject>> futureJM(T entity, String field) {
        return list -> Future.succeededFuture((Object)To.toMerge(entity, field, list));
    }

    public static Future<JsonObject> futureJ() {
        return Ux.futureJ(new JsonObject(), "");
    }

    public static Future<JsonObject> futureJ(Throwable ex) {
        return Async.toErrorFuture(JsonObject::new).apply(ex);
    }

    public static <T> Future<JsonObject> futureJ(T entity) {
        return Ux.futureJ(entity, "");
    }

    public static <T> Function<T, Future<JsonObject>> futureJ(String pojo) {
        return entity -> Ux.futureJ(entity, pojo);
    }

    public static <T> Future<List<JsonObject>> futureL(List<T> list, String pojo) {
        return Future.succeededFuture(To.toJList(list, pojo));
    }

    public static <T> Future<List<JsonObject>> futureL() {
        return Ux.futureL(new ArrayList(), "");
    }

    public static <T> Future<List<JsonObject>> futureL(List<T> list) {
        return Ux.futureL(list, "");
    }

    public static <T> Function<List<T>, Future<List<JsonObject>>> futureL(String pojo) {
        return list -> Ux.futureL(list, pojo);
    }

    public static Future<JsonObject> futureJ(Record record) {
        return (Future)Fn.getNull(Ux.futureJ(), () -> To.future(record.toJson()), (Object[])new Object[]{record});
    }

    public static Future<JsonArray> futureA(Record[] records) {
        return (Future)Fn.getNull(Ux.futureA(), () -> To.future(Ut.toJArray((Record[])records)), (Object[])records);
    }

    public static <T> Future<ConcurrentMap<String, JsonArray>> futureG(List<T> item, String field) {
        return Ux.futureG(To.toJArray(item, ""), field);
    }

    public static Future<ConcurrentMap<String, JsonArray>> futureG(JsonArray item, String field) {
        return Future.succeededFuture((Object)Ut.elementGroup((JsonArray)item, (String)field));
    }

    public static <T> Future<ConcurrentMap<String, JsonArray>> futureG(List<T> item) {
        return Ux.futureG(To.toJArray(item, ""), "type");
    }

    public static Future<ConcurrentMap<String, JsonArray>> futureG(JsonArray item) {
        return Ux.futureG(item, "type");
    }

    public static <T> Function<JsonObject, Future<JsonObject>> attach(String field, Function<T, Future<JsonObject>> function) {
        return Web.toAttach(field, function);
    }

    public static <T> Function<JsonObject, Future<JsonObject>> attachJ(String field, Function<T, Future<JsonObject>> function) {
        return Web.toAttachJ(field, function);
    }

    public static JsonObject pageData() {
        return Web.pageData(new JsonArray(), 0L);
    }

    public static JsonObject pageData(JsonArray data, long size) {
        return Web.pageData(data, size);
    }

    public static JsonArray pageData(JsonObject data) {
        return Ut.sureJArray((JsonArray)data.getJsonArray("list"));
    }

    public static JsonObject pageData(JsonObject pageData, Function<JsonArray, JsonArray> function) {
        return Web.pageData(pageData, function);
    }

    public static Future<JsonArray> thenCombine(Future<JsonArray> source, Function<JsonObject, Future<JsonObject>> generateFun, BinaryOperator<JsonObject> operatorFun) {
        return Combine.thenCombine(source, generateFun, operatorFun);
    }

    public static Future<JsonObject> thenCombine(JsonObject source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return Combine.thenCombine((Future<JsonObject>)Future.succeededFuture((Object)source), generateFun, operatorFun);
    }

    public static Future<JsonArray> thenCombine(List<Future<JsonObject>> futures) {
        return Combine.thenCombine(futures);
    }

    public static <F, S, T> Future<T> thenCombine(Supplier<Future<F>> futureF, Supplier<Future<S>> futureS, BiFunction<F, S, Future<T>> consumer) {
        return Combine.thenCombine(futureF, futureS, consumer);
    }

    public static <F, S, T> Future<T> thenCombine(Future<F> futureF, Future<S> futureS, BiFunction<F, S, Future<T>> consumer) {
        return Combine.thenCombine(() -> futureF, () -> futureS, consumer);
    }

    public static Future<JsonArray> thenCombine(JsonArray input, Function<JsonObject, Future<JsonObject>> function) {
        ArrayList<Future<JsonObject>> futures = new ArrayList<Future<JsonObject>>();
        Ut.itJArray((JsonArray)input).map(function).forEach(futures::add);
        return Combine.thenCombine(futures);
    }

    public static <T> Future<List<T>> thenCombineT(List<Future<T>> futures) {
        return Combine.thenCombineT(futures);
    }

    public static <I, O> Future<List<O>> thenCombineT(List<I> source, Function<I, Future<O>> consumer) {
        ArrayList futures = new ArrayList();
        Ut.itList(source).map(consumer).forEach(futures::add);
        return Combine.thenCombineT(futures);
    }

    public static <K, T> Future<ConcurrentMap<K, T>> thenCombine(ConcurrentMap<K, Future<T>> futureMap) {
        return Combine.thenCombine(futureMap);
    }

    public static Future<JsonArray> thenCombineArray(List<Future<JsonArray>> futures) {
        return Combine.thenCombineArray(futures);
    }

    public static Future<JsonArray> thenCombineArray(JsonArray source, Function<JsonObject, Future<JsonArray>> consumer) {
        return Ux.thenCombineArray(source, JsonObject.class, consumer);
    }

    public static <T> Future<JsonArray> thenCombineArray(JsonArray source, Class<T> clazz, Function<T, Future<JsonArray>> consumer) {
        ArrayList<Future<JsonArray>> futures = new ArrayList<Future<JsonArray>>();
        Ut.itJArray((JsonArray)source, clazz, (item, index) -> futures.add((Future)consumer.apply(item)));
        return Combine.thenCombineArray(futures);
    }

    public static <T> Future<List<T>> thenCombineArrayT(List<Future<List<T>>> futures) {
        return Combine.thenCombineArrayT(futures);
    }

    public static Future<ConcurrentMap<String, JsonArray>> thenCompress(List<Future<ConcurrentMap<String, JsonArray>>> futures) {
        return Combine.thenCompress(futures, (original, latest) -> original.addAll(latest));
    }

    public static <T> Future<T> thenError(Class<? extends WebException> clazz, Object ... args) {
        return Combine.thenError(clazz, args);
    }

    public static <T> Future<T> thenErrorSigma(Class<?> clazz, String sigma, Supplier<Future<T>> supplier) {
        return Combine.thenErrorSigma(clazz, sigma, supplier);
    }

    public static JsonObject whereDay(JsonObject filters, String field, Instant instant) {
        return Where.whereDay(filters, field, instant);
    }

    public static JsonObject whereDay(JsonObject filters, String field, LocalDateTime instant) {
        return Where.whereDay(filters, field, Ut.parse((LocalDateTime)instant).toInstant());
    }

    public static JsonObject whereKeys(Set<String> keys) {
        return Where.whereKeys(Ut.toJArray(keys));
    }

    public static JsonObject whereKeys(JsonArray keys) {
        return Where.whereKeys(keys);
    }

    public static JsonObject whereAnd() {
        return Where.whereAnd();
    }

    public static JsonObject whereAnd(String field, Object value) {
        return Where.whereAnd().put(field, value);
    }

    public static JsonObject whereOr() {
        return Where.whereOr();
    }

    public static JsonObject whereOr(String field, Object value) {
        return Where.whereOr().put(field, value);
    }

    public static JsonArray getArray(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, JsonArray.class);
    }

    public static JsonArray getArray(Envelop envelop) {
        return In.request(envelop, (Integer)0, JsonArray.class);
    }

    public static JsonArray getArray1(Envelop envelop) {
        return In.request(envelop, (Integer)1, JsonArray.class);
    }

    public static JsonArray getArray2(Envelop envelop) {
        return In.request(envelop, (Integer)2, JsonArray.class);
    }

    public static String getString(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, String.class);
    }

    public static String getString(Envelop envelop) {
        return In.request(envelop, (Integer)0, String.class);
    }

    public static String getString1(Envelop envelop) {
        return In.request(envelop, (Integer)1, String.class);
    }

    public static String getString2(Envelop envelop) {
        return In.request(envelop, (Integer)2, String.class);
    }

    public static Vis getVis(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Vis.class);
    }

    public static Vis getVis(Envelop envelop) {
        return In.request(envelop, (Integer)0, Vis.class);
    }

    public static Vis getVis1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Vis.class);
    }

    public static Vis getVis2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Vis.class);
    }

    public static JsonObject getJson(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, JsonObject.class);
    }

    public static <T> T fromEnvelop(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson(envelop), clazz, pojo);
    }

    public static JsonObject fromEnvelop(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson(envelop), pojo);
    }

    public static JsonObject getJson(Envelop envelop) {
        return In.request(envelop, (Integer)0, JsonObject.class);
    }

    public static <T> T fromEnvelop1(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson1(envelop), clazz, pojo);
    }

    public static JsonObject fromEnvelop1(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson1(envelop), pojo);
    }

    public static JsonObject getJson1(Envelop envelop) {
        return In.request(envelop, (Integer)1, JsonObject.class);
    }

    public static JsonObject getJson2(Envelop envelop) {
        return In.request(envelop, (Integer)2, JsonObject.class);
    }

    public static JsonObject fromEnvelop2(Envelop envelop, String pojo) {
        return From.fromJson(Ux.getJson2(envelop), pojo);
    }

    public static <T> T fromEnvelop2(Envelop envelop, Class<T> clazz, String pojo) {
        return From.fromJson(Ux.getJson2(envelop), clazz, pojo);
    }

    public static Integer getInteger(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Integer.class);
    }

    public static Integer getInteger(Envelop envelop) {
        return In.request(envelop, (Integer)0, Integer.class);
    }

    public static Integer getInteger1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Integer.class);
    }

    public static Integer getInteger2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Integer.class);
    }

    public static Long getLong(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Long.class);
    }

    public static Long getLong(Envelop envelop) {
        return In.request(envelop, (Integer)0, Long.class);
    }

    public static Long getLong1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Long.class);
    }

    public static Long getLong2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Long.class);
    }

    public static <T> T getT(Envelop envelop, int index, Class<T> clazz) {
        return In.request(envelop, (Integer)index, clazz);
    }

    public static <T> T getT(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)0, clazz);
    }

    public static <T> T getT1(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)1, clazz);
    }

    public static <T> T getT2(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)2, clazz);
    }

    public static JsonObject getBody(Envelop envelop) {
        return In.request(envelop, JsonObject.class);
    }

    public static <T> T getBodyT(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, clazz);
    }

    public static void nativeInit(JsonObject init) {
        Atomic.nativeInit(init);
    }

    public static Vertx nativeVertx() {
        return Atomic.nativeVertx();
    }

    public static WorkerExecutor nativeWorker(String name) {
        return Atomic.nativeWorker(name, 10);
    }

    public static WorkerExecutor nativeWorker(String name, Integer minutes) {
        return Atomic.nativeWorker(name, minutes);
    }

    public static ConcurrentMap<String, DiConsumer> dictEpsilon(JsonObject epsilon) {
        return DiTool.mapEpsilon(epsilon);
    }

    public static Future<ConcurrentMap<String, JsonArray>> dictCalc(DiSetting dict, MultiMap paramsMap) {
        return DiTool.dictCalc(dict, paramsMap);
    }

    public static <T> Future<T> dictTo(T record, DiFabric fabric) {
        return DiTool.dictTo(record, fabric);
    }

    public static String keyUser(User user) {
        Objects.requireNonNull(user);
        JsonObject principle = user.principal();
        String accessToken = principle.getString("access_token");
        JsonObject credential = Jwt.extract(accessToken);
        return credential.getString("user");
    }

    public static class Jwt {
        public static String token(JsonObject data) {
            Lee lee = (Lee)Ut.service(LeeBuiltIn.class);
            return lee.encode(data, AegisItem.configMap((AuthWall)AuthWall.JWT));
        }

        public static JsonObject extract(String token) {
            Lee lee = (Lee)Ut.service(LeeBuiltIn.class);
            return lee.decode(token, AegisItem.configMap((AuthWall)AuthWall.JWT));
        }

        public static JsonObject extract(JsonObject jwtToken) {
            return Jwt.extract(jwtToken.getString("access_token"));
        }
    }

    public static class Timer {
        public static UxTimer on() {
            return new UxTimer();
        }
    }

    public static class Opt {
        public static UxOpt on() {
            return new UxOpt();
        }
    }

    public static class Job {
        public static UxJob on() {
            return new UxJob();
        }
    }

    public static class Pool {
        public static UxPool on(String name) {
            return (UxPool)Fn.pool(Cache.MAP_POOL, (Object)name, () -> new UxPool(name));
        }

        public static UxPool on() {
            return new UxPool();
        }
    }

    public static class Join {
        public static UxJoin on(String configFile) {
            return new UxJoin(configFile);
        }

        public static UxJoin on() {
            return new UxJoin(null);
        }
    }

    public static class Jooq {
        public static UxJooq ons(Class<?> clazz) {
            JooqDsl dsl = JooqInfix.getDao(clazz, (String)"orbit");
            return (UxJooq)Fn.pool(Cache.JOOQ_POOL_HIS, (Object)dsl.poolKey(), () -> new UxJooq(clazz, dsl));
        }

        public static UxJooq on(Class<?> clazz) {
            JooqDsl dsl = JooqInfix.getDao(clazz);
            return (UxJooq)Fn.pool(Cache.JOOQ_POOL, (Object)dsl.poolKey(), () -> new UxJooq(clazz, dsl));
        }

        public static UxJooq on(Class<?> clazz, DataPool pool) {
            JooqDsl dsl = JooqInfix.getDao(clazz, (DataPool)pool);
            return (UxJooq)Fn.pool(Cache.JOOQ_POOL, (Object)dsl.poolKey(), () -> new UxJooq(clazz, dsl));
        }

        public static UxJooq on(Class<?> clazz, String key) {
            JooqDsl dsl = JooqInfix.getDao(clazz, (String)key);
            return (UxJooq)Fn.pool(Cache.JOOQ_POOL, (Object)dsl.poolKey(), () -> new UxJooq(clazz, dsl));
        }

        public static boolean isEmpty(JsonObject condition) {
            if (Ut.isNil((JsonObject)condition)) {
                return true;
            }
            JsonObject normalized = condition.copy();
            normalized.remove("");
            return Ut.isNil((JsonObject)normalized);
        }
    }
}

