/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.job.JobClient;
import io.vertx.tp.plugin.job.JobInfix;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;

public class UxJob {
    private static final Annal LOGGER = Annal.get(UxJob.class);
    private final transient JobClient client = JobInfix.getClient();

    UxJob() {
    }

    public Future<Boolean> startAsync(String code) {
        return Fn.thenGeneric(future -> this.client.startAsync(code, (Handler<AsyncResult<Long>>)((Handler)res -> {
            LOGGER.info("( UxJob ) The job {0} has been started with timeId: {1}.", new Object[]{code, res.result()});
            future.complete((Object)Boolean.TRUE);
        })));
    }

    public Future<Boolean> stopAsync(String code) {
        return Fn.thenGeneric(future -> this.client.stopAsync(code, (Handler<AsyncResult<Boolean>>)((Handler)res -> {
            LOGGER.info("( UxJob ) The job {0} has been stopped and removed.", new Object[]{code});
            future.complete((Object)Boolean.TRUE);
        })));
    }

    public Future<Boolean> resumeAsync(String code) {
        return Fn.thenGeneric(future -> this.client.resumeAsync(code, (Handler<AsyncResult<Long>>)((Handler)res -> {
            LOGGER.info("( UxJob ) The job {0} will be resume.", new Object[]{code});
            future.complete((Object)Boolean.TRUE);
        })));
    }

    public Future<JsonObject> statusAsync(String namespace) {
        return this.client.statusAsync(namespace);
    }
}

