/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.unity;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class UxTimer {
    private transient long start;
    private transient long end;

    UxTimer() {
    }

    @Fluent
    public UxTimer start(long start) {
        this.start = start;
        return this;
    }

    @Fluent
    public UxTimer end(long end) {
        this.end = end;
        return this;
    }

    public String value() {
        long duration = this.end - this.start;
        LocalDateTime datetime = Ut.toDuration((long)duration);
        DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        return format.format(datetime);
    }
}

