/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.booting;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.booting.KBoot;
import io.vertx.tp.plugin.booting.KConnect;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public abstract class AbstractBoot
implements KBoot {
    private final transient ConcurrentMap<String, KConnect> connects = new ConcurrentHashMap<String, KConnect>();
    private final transient ConcurrentMap<String, JsonObject> modules = new ConcurrentHashMap<String, JsonObject>();
    private final transient ConcurrentMap<String, JsonArray> columns = new ConcurrentHashMap<String, JsonArray>();
    private final transient List<String> files = new ArrayList<String>();
    private final transient String root;

    public AbstractBoot(String module) {
        this.root = "plugin/" + module + "/oob/";
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    @Override
    public ConcurrentMap<String, KConnect> configure() {
        if (this.connects.isEmpty()) {
            String excelYaml = this.root + "initialize.yml";
            JsonArray data = (JsonArray)Ut.ioYaml((String)excelYaml);
            List connectList = Ut.deserialize((JsonArray)data, (TypeReference)new TypeReference<List<KConnect>>(){});
            connectList.stream().filter(Objects::nonNull).filter(connect -> Objects.nonNull(connect.getTable())).forEach(connect -> this.connects.put(connect.getTable(), (KConnect)connect));
            JsonArray fileData = Ut.ioJArray((String)(this.root + "initialize.json"));
            Ut.itJArray((JsonArray)fileData, String.class, (item, index) -> this.files.add((String)item));
            this.files.addAll(this.configureBuiltIn());
        }
        return this.connects;
    }

    protected Set<String> configureBuiltIn() {
        return new HashSet<String>();
    }

    @Override
    public List<String> oob() {
        return this.files;
    }

    @Override
    public List<String> oob(String prefix) {
        String prefixFile = Objects.isNull(prefix) ? "" : prefix;
        return this.files.stream().filter(item -> item.contains(prefixFile)).collect(Collectors.toList());
    }

    @Override
    public ConcurrentMap<String, JsonObject> module() {
        if (this.modules.isEmpty()) {
            Set<String> modules = this.moduleSet();
            modules.forEach(item -> {
                String moduleJson = this.root + "module/crud/" + item + ".json";
                JsonObject module = Ut.ioJObject((String)moduleJson);
                if (Ut.notNil((JsonObject)module)) {
                    this.modules.put((String)item, module);
                }
            });
        }
        return this.modules;
    }

    @Override
    public ConcurrentMap<String, JsonArray> column() {
        if (this.columns.isEmpty()) {
            Set<String> modules = this.moduleSet();
            modules.forEach(item -> {
                String moduleJson = this.root + "module/ui/" + item + ".json";
                JsonArray module = Ut.ioJArray((String)moduleJson);
                if (Ut.notNil((JsonArray)module)) {
                    this.columns.put((String)item, module);
                }
            });
        }
        return this.columns;
    }

    private Set<String> moduleSet() {
        String moduleJson = this.root + "module.json";
        JsonArray module = Ut.ioJArray((String)moduleJson);
        return Ut.toSet((JsonArray)module);
    }
}

