/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.job;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.job.JobClientImpl;
import io.vertx.tp.plugin.job.JobPool;
import io.vertx.up.atom.worker.Mission;
import java.util.List;
import java.util.Set;

public interface JobClient {
    public static JobClient createShared(Vertx vertx, JsonObject config) {
        return new JobClientImpl(vertx, config);
    }

    public static JobClient createShared(Vertx vertx) {
        return new JobClientImpl(vertx, new JsonObject());
    }

    public static void bind(Long timerId, String code) {
        JobPool.bind(timerId, code);
    }

    public static String code(String name) {
        return "zero.vertx.jobs-" + name;
    }

    @Fluent
    public JobClient startAsync(String var1, Handler<AsyncResult<Long>> var2);

    public Future<Long> startAsync(String var1);

    @Fluent
    public JobClient stopAsync(String var1, Handler<AsyncResult<Boolean>> var2);

    public Future<Boolean> stopAsync(String var1);

    @Fluent
    public JobClient resumeAsync(String var1, Handler<AsyncResult<Long>> var2);

    public Future<Long> resumeAsync(String var1);

    @Fluent
    public JobClient fetchAsync(String var1, Handler<AsyncResult<Mission>> var2);

    @Fluent
    public JobClient fetchAsync(Set<String> var1, Handler<AsyncResult<List<Mission>>> var2);

    public Future<Mission> fetchAsync(String var1);

    public Future<List<Mission>> fetchAsync(Set<String> var1);

    public Mission fetch(String var1);

    public List<Mission> fetch(Set<String> var1);

    @Fluent
    public JobClient saveAsync(Set<Mission> var1, Handler<AsyncResult<Set<Mission>>> var2);

    public Future<Set<Mission>> saveAsync(Set<Mission> var1);

    @Fluent
    public JobClient saveAsync(Mission var1, Handler<AsyncResult<Mission>> var2);

    public Future<Mission> saveAsync(Mission var1);

    public Set<Mission> save(Set<Mission> var1);

    public Mission save(Mission var1);

    @Fluent
    public JobClient removeAsync(String var1, Handler<AsyncResult<Mission>> var2);

    public Future<Mission> removeAsync(String var1);

    public Mission remove(String var1);

    public JsonObject status(String var1);

    public Future<JsonObject> statusAsync(String var1);

    @Fluent
    public JobClient statusAsync(String var1, Handler<AsyncResult<JsonObject>> var2);

    public static final class Pre {
        public static void save(Set<Mission> missions) {
            missions.forEach(JobPool::save);
        }

        public static void save(Mission mission) {
            JobPool.save(mission);
        }
    }
}

