/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.session;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.tp.plugin.session.SessionClient;
import io.vertx.up.eon.em.StoreType;
import io.vertx.up.exception.web._500SessionClientInitException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.concurrent.atomic.AtomicBoolean;

public class SessionClientImpl
implements SessionClient {
    private static final Annal LOGGER = Annal.get(SessionClientImpl.class);
    private static final AtomicBoolean LOG_MSG = new AtomicBoolean(true);
    private static SessionStore STORE;
    private final transient Vertx vertx;

    private SessionClientImpl(Vertx vertx, JsonObject config, StoreType type) {
        this.vertx = vertx;
        if (null == STORE) {
            if (LOG_MSG.getAndSet(Boolean.FALSE)) {
                LOGGER.info("( Session ) System will selected mode = \"{0}\" of session.", new Object[]{type});
            }
            if (StoreType.LOCAL == type) {
                STORE = LocalSessionStore.create((Vertx)vertx);
            } else if (StoreType.CLUSTER == type) {
                STORE = ClusteredSessionStore.create((Vertx)this.vertx);
            } else {
                String store = config.getString("store");
                Fn.outWeb((boolean)Ut.isNil((String)store), _500SessionClientInitException.class, (Object[])new Object[]{this.getClass()});
                LOGGER.info("( Session ) SessionStore clazz selected: {0}", new Object[]{store});
                SessionStore defined = (SessionStore)Ut.singleton((String)store, (Object[])new Object[0]);
                JsonObject opts = config.getJsonObject("options");
                if (Ut.isNil((JsonObject)opts)) {
                    opts = new JsonObject();
                }
                STORE = defined.init(vertx, opts);
            }
        }
    }

    static SessionClientImpl create(Vertx vertx, JsonObject config) {
        String type = config.getString("category");
        if ("CLUSTER".equals(type)) {
            return new SessionClientImpl(vertx, config, StoreType.CLUSTER);
        }
        if ("DEFINED".equals(type)) {
            return new SessionClientImpl(vertx, config, StoreType.DEFINED);
        }
        return new SessionClientImpl(vertx, config, StoreType.LOCAL);
    }

    @Override
    public SessionHandler getHandler() {
        return SessionHandler.create((SessionStore)STORE).setCookieHttpOnlyFlag(true);
    }

    @Override
    public Future<Session> get(String id) {
        Promise promise = Promise.promise();
        STORE.get(id, result -> {
            if (result.succeeded()) {
                promise.complete((Object)((Session)result.result()));
            } else {
                promise.complete(null);
            }
        });
        return promise.future();
    }

    @Override
    public Future<Session> open(String sessionId) {
        return Future.succeededFuture((Object)STORE.createSession(2000L));
    }
}

